<?php
/**
 * Anti-Bot Admin Panel
 * Manage blacklist, whitelist, and view logs
 */

require_once 'antibot.php';

// Simple authentication (change these credentials)
$admin_username = 'Admin';
$admin_password = 'Shadow';

session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    if (isset($_POST['username']) && isset($_POST['password'])) {
        if ($_POST['username'] === $admin_username && $_POST['password'] === $admin_password) {
            $_SESSION['admin_logged_in'] = true;
        } else {
            $error = 'Invalid credentials';
        }
    }
    
    if (!isset($_SESSION['admin_logged_in'])) {
        ?>
        <!DOCTYPE html>
        <html>
        <head>
            <title>Anti-Bot Admin Login</title>
            <style>
                body { font-family: Arial, sans-serif; background: #f5f5f5; padding: 50px; }
                .login-form { background: white; padding: 30px; border-radius: 10px; max-width: 400px; margin: 0 auto; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
                input { width: 100%; padding: 10px; margin: 10px 0; border: 1px solid #ddd; border-radius: 5px; }
                button { background: #007cba; color: white; padding: 12px 20px; border: none; border-radius: 5px; cursor: pointer; width: 100%; }
                .error { color: red; margin: 10px 0; }
            </style>
        </head>
        <body>
            <div class="login-form">
                <h2>Anti-Bot Admin Panel</h2>
                <?php if (isset($error)) echo "<div class='error'>$error</div>"; ?>
                <form method="POST">
                    <input type="text" name="username" placeholder="Username" required>
                    <input type="password" name="password" placeholder="Password" required>
                    <button type="submit">Login</button>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// Handle admin actions
if (isset($_POST['action'])) {
    $antiBot = new AdvancedAntiBot();
    
    switch ($_POST['action']) {
        case 'add_whitelist':
            if (!empty($_POST['identifier'])) {
                $antiBot->addToWhitelist($_POST['identifier'], $_POST['reason'] ?? '');
                $success = 'Added to whitelist successfully';
            }
            break;
            
        case 'remove_blacklist':
            if (!empty($_POST['identifier'])) {
                $antiBot->removeFromBlacklist($_POST['identifier']);
                $success = 'Removed from blacklist successfully';
            }
            break;
            
        case 'clear_logs':
            file_put_contents('antibot.log', '');
            $success = 'Logs cleared successfully';
            break;
    }
}

// Get current data
$blacklist = file_exists('blacklist.txt') ? file_get_contents('blacklist.txt') : '';
$whitelist = file_exists('whitelist.txt') ? file_get_contents('whitelist.txt') : '';
$logs = file_exists('antibot.log') ? array_reverse(explode("\n", file_get_contents('antibot.log'))) : [];
$logs = array_slice(array_filter($logs), 0, 100); // Show last 100 entries

?>
<!DOCTYPE html>
<html>
<head>
    <title>Anti-Bot Admin Panel</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 0; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; }
        .header { background: #007cba; color: white; padding: 20px; border-radius: 10px; margin-bottom: 20px; }
        .section { background: white; padding: 20px; border-radius: 10px; margin-bottom: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .tabs { display: flex; margin-bottom: 20px; }
        .tab { padding: 10px 20px; background: #ddd; border: none; cursor: pointer; margin-right: 5px; border-radius: 5px 5px 0 0; }
        .tab.active { background: #007cba; color: white; }
        .tab-content { display: none; }
        .tab-content.active { display: block; }
        textarea { width: 100%; height: 300px; font-family: monospace; }
        input, button { padding: 10px; margin: 5px; border: 1px solid #ddd; border-radius: 5px; }
        button { background: #007cba; color: white; border: none; cursor: pointer; }
        .success { color: green; padding: 10px; background: #e8f5e8; border-radius: 5px; margin: 10px 0; }
        .log-entry { padding: 10px; border-bottom: 1px solid #eee; font-family: monospace; font-size: 12px; }
        .blocked { background: #ffe6e6; }
        .allowed { background: #e6ffe6; }
        .stats { display: flex; gap: 20px; }
        .stat-box { flex: 1; text-align: center; padding: 20px; background: #f8f9fa; border-radius: 10px; }
        .logout { float: right; background: #dc3545; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🛡️ Anti-Bot Admin Panel</h1>
            <a href="?logout=1" class="logout" style="color: white; text-decoration: none; padding: 10px 15px; background: #dc3545; border-radius: 5px;">Logout</a>
        </div>
        
        <?php if (isset($success)) echo "<div class='success'>$success</div>"; ?>
        
        <div class="section">
            <div class="stats">
                <div class="stat-box">
                    <h3>Blacklisted IPs</h3>
                    <h2><?php echo substr_count($blacklist, "\n"); ?></h2>
                </div>
                <div class="stat-box">
                    <h3>Whitelisted IPs</h3>
                    <h2><?php echo substr_count($whitelist, "\n"); ?></h2>
                </div>
                <div class="stat-box">
                    <h3>Log Entries</h3>
                    <h2><?php echo count($logs); ?></h2>
                </div>
            </div>
        </div>
        
        <div class="section">
            <div class="tabs">
                <button class="tab active" onclick="showTab('blacklist')">Blacklist</button>
                <button class="tab" onclick="showTab('whitelist')">Whitelist</button>
                <button class="tab" onclick="showTab('logs')">Logs</button>
                <button class="tab" onclick="showTab('config')">Configuration</button>
            </div>
            
            <div id="blacklist" class="tab-content active">
                <h3>Blacklisted IPs and Fingerprints</h3>
                <textarea readonly><?php echo htmlspecialchars($blacklist); ?></textarea>
                <form method="POST" style="margin-top: 10px;">
                    <input type="hidden" name="action" value="remove_blacklist">
                    <input type="text" name="identifier" placeholder="IP or Fingerprint to remove" required>
                    <button type="submit">Remove from Blacklist</button>
                </form>
            </div>
            
            <div id="whitelist" class="tab-content">
                <h3>Whitelisted IPs and Fingerprints</h3>
                <textarea readonly><?php echo htmlspecialchars($whitelist); ?></textarea>
                <form method="POST" style="margin-top: 10px;">
                    <input type="hidden" name="action" value="add_whitelist">
                    <input type="text" name="identifier" placeholder="IP or Fingerprint to whitelist" required>
                    <input type="text" name="reason" placeholder="Reason (optional)">
                    <button type="submit">Add to Whitelist</button>
                </form>
            </div>
            
            <div id="logs" class="tab-content">
                <h3>Recent Activity Logs</h3>
                <button onclick="if(confirm('Clear all logs?')) { document.getElementById('clearLogs').submit(); }">Clear Logs</button>
                <form id="clearLogs" method="POST" style="display: none;">
                    <input type="hidden" name="action" value="clear_logs">
                </form>
                <div style="max-height: 500px; overflow-y: auto; margin-top: 10px;">
                    <?php foreach ($logs as $log): ?>
                        <?php 
                        $logData = json_decode($log, true);
                        if ($logData):
                            $class = strpos($logData['action'], 'BLOCKED') !== false ? 'blocked' : 'allowed';
                        ?>
                        <div class="log-entry <?php echo $class; ?>">
                            <strong><?php echo $logData['timestamp']; ?></strong> - 
                            <?php echo $logData['ip']; ?> - 
                            <?php echo $logData['action']; ?>
                            <?php if (!empty($logData['url'])): ?>
                                - <?php echo $logData['url']; ?>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <div id="config" class="tab-content">
                <h3>Configuration</h3>
                <p>Edit the configuration file: <code>antibot/config.json</code></p>
                <textarea readonly><?php echo file_get_contents('config.json'); ?></textarea>
            </div>
        </div>
    </div>
    
    <script>
        function showTab(tabName) {
            // Hide all tab contents
            var contents = document.querySelectorAll('.tab-content');
            contents.forEach(function(content) {
                content.classList.remove('active');
            });
            
            // Remove active class from all tabs
            var tabs = document.querySelectorAll('.tab');
            tabs.forEach(function(tab) {
                tab.classList.remove('active');
            });
            
            // Show selected tab content
            document.getElementById(tabName).classList.add('active');
            
            // Add active class to clicked tab
            event.target.classList.add('active');
        }
    </script>
</body>
</html>

<?php
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: admin.php');
    exit;
}
?>